///////////////////////////////////////////////////////////////////////////
// Copyright (c) Panos Kougiouris 1997
///////////////////////////////////////////////////////////////////////////

#include <kfThread.h>
#include <kfReferenceCount.h>
#include "kfMutexWin32.h"

class CKFMTConditionImplementation : public CKFReferenceCount {
  public:
    HANDLE m_event;
    int    m_waiters;
    
    CKFMTConditionImplementation(const char* name)
    {
        m_event = CreateEvent(NULL, // default security
                                  FALSE,   // auto-reset
                                  FALSE,  // non sigaled originally
                                  name);
        m_waiters = 0;
    }

  private:
    ~CKFMTConditionImplementation()
    {
        CloseHandle(m_event);
    }
};


//--------------------------------------------------------

CKFMT::CCondition::CCondition(const char* a_name)
{
    m_impl = new CKFMTConditionImplementation(a_name);   
}

//--------------------------------------------------------

CKFMT::CCondition::CCondition(const CCondition& a_m)
{
    m_impl = a_m.m_impl;
    m_impl->increment();
}

//--------------------------------------------------------

CKFMT::CCondition& 
CKFMT::CCondition::operator= (const CKFMT::CCondition& a_m)
{ 
    m_impl->decrement();
    m_impl = a_m.m_impl;
    m_impl->increment();

    return *this;
}

//--------------------------------------------------------

CKFMT::CCondition::~CCondition()
{
    m_impl->decrement();
}

//--------------------------------------------------------

CKFMT::RetValue
CKFMT::CCondition::wait(CKFMT::CMutex a_mut, unsigned msecs)
{
    CKFMT::RetValue ret = Ok;
    assert(a_mut.am_owner());

    if (msecs == Infinity) msecs = INFINITE;
    m_impl->m_waiters++;
    a_mut.m_impl->m_last_owner = -1;
    DWORD wret = SignalObjectAndWait(a_mut.m_impl->m_mutex, 
                        m_impl->m_event, msecs, FALSE);
    a_mut.lock();
    m_impl->m_waiters--;
    if (wret == WAIT_FAILED) {
        ret = Error;
    } else if (wret == WAIT_TIMEOUT) {
        ret = Timeout;
    }
    return ret;
}

//--------------------------------------------------------

CKFMT::RetValue
CKFMT::CCondition::signal()
{
    BOOL ret = PulseEvent(m_impl->m_event);
    if (ret == FALSE) {
        return Error;
    }
    return Ok;
}

//--------------------------------------------------------

CKFMT::RetValue
CKFMT::CCondition::broadcast()
{
    int count = m_impl->m_waiters;
    while (count--) {
        PulseEvent(m_impl->m_event);
    }
    return Ok;
}
