///////////////////////////////////////////////////////////////////////////
// Copyright (c) Panos Kougiouris 1997
///////////////////////////////////////////////////////////////////////////

#include <kfThread.h>
#include <kfReferenceCount.h>
#include <pthread.h>
#include <errno.h>
#include <assert.h>

class CKFMTMutexImplementation : public CKFReferenceCount {
  public:
    pthread_mutex_t        m_mutex;
    pthread_mutexattr_t    mut_attr;
    unsigned long          m_last_owner;
    
    CKFMTMutexImplementation(const char* name)
    {
        pthread_mutexattr_init(&mut_attr);
        pthread_mutexattr_setpshared(&mut_attr, PTHREAD_PROCESS_PRIVATE);
        int ret = pthread_mutex_init(&m_mutex, &mut_attr);
        assert(ret == 0);
        m_last_owner = -1;
    }

  private:
    ~CKFMTMutexImplementation()
    {
        pthread_mutexattr_destroy(&mut_attr);
        int ret = pthread_mutex_destroy(&m_mutex);
	assert(ret == 0);
    }
};

