///////////////////////////////////////////////////////////////////////////
// Copyright (c) Panos Kougiouris 1997
///////////////////////////////////////////////////////////////////////////

#include <kfThread.h>
#include <string.h>
#include <stdlib.h>
#include "kfRunnable.h"

CKFMT::CRunnable::CRunnable(const char* a_name) 
{
    m_impl = new CKFMTRunnableImplementation;
    m_impl->m_name = strdup(a_name);
}

//------------------------------------------------------------

CKFMT::CRunnable::~CRunnable()
{
    assert(m_impl != NULL);
    free(m_impl->m_name);
    delete m_impl;
}

//-----------------------------------------------------------
const char* 
CKFMT::CRunnable::get_name()
{
    return m_impl->m_name;
}
//-----------------------------------------------------------

CKFMT::RetValue
CKFMT::CRunnable::wait_for_completion(unsigned msecs)
{
    CKFMT::CMutexGrabber m(m_impl->m_mutex);

    while (!m_impl->m_completed) {
	CKFMT::RetValue rv = m_impl->m_done.wait(m_impl->m_mutex, msecs);
	if (rv == Timeout)
	    return rv;
    }
    return Ok;
}

//------------------------------------------------------------
//------------------------------------------------------------

void
CKFMTRunnableImplementation::completed()
{
    CKFMT::CMutexGrabber m(m_mutex);
    m_completed = CKFTrue;
    m_done.broadcast();
}

//------------------------------------------------------------



