Listing 2:
/*--------------------------------------------------------------
  vbe.h           vbe.c exports and data types
--------------------------------------------------------------*/

typedef struct
{
	char	VbeSignature[4];	/* "VESA" */
	int		VbeVersion;			/* bcd */
	char 	far *OemStringPtr;	/* asciiz */
	long 	Capabilities;		/* of video, bitmapped */
	int		far *VideoModePtr;	/* array of svga mode numbers */
	int		TotalMemory;		/* video memory/64kb */
	
	/* vbe 2.0+ */
	int		OemSoftwareRev;			/* bcd */
	char	far *OemVendorNamePtr;	/* asciiz */
	char	far *OemProductNamePtr;	/* asciiz */
	char	far	*OemProductRevPtr;	/* asciiz */
	char	Reserved[222];			/* used by vbe */
	char	OemData[256];			/* used by vbe */
	
} VbeInfo_t;

typedef struct
{
	int		ModeAttributes;	/* bitmapped */
	char	WinAAttributes;	/* bitmapped */
	char	WinBAttributes;
	int		WinGranularity;	/* in Kb */
	int		WinSize;		/* in Kb */
	int		WinASegment;	/* start segment */
	int		WinBSegment;
	void	far *WinFuncPtr;/* to window control function */
	int		BytesPerScanLine;
	
	/* vbe 1.2+ */
	int		XResolution;		/* in pixels or coloumns */
	int		YResolution;		/* in pixels or rows */
	char	XCharSize;			/* char cell width in pixels */
	char	YCharSize;			/* char cell depth in pixels */
	char	NumberOfPlanes;		/* memory planes */
	char	BitsPerPixel;		/* color resolution */
	char	NumberOfBanks;
	char	MemoryModel;		/* values defined by vesa */
	char	BankSize;			/* in Kb */
	char	NumberOfImagePages;
	char	Reserved1;			/* 1: for page function */
	
	/* direct color fields */
	char	RedMaskSize;		/* size of dc mask in bits */
	char	RedFieldPosition;	/* bit position of mask lsb */
	char	GreenMaskSize;
	char	GreenFieldPosition;
	char	BlueMaskSize;
	char	BlueFieldPosition;
	char	RsvdMaskSize;
	char	RsvdFieldPosition;
	char	DirectColorModeInfo;/* bitmapped */
	
	/* vbe 2.0+ */
	void	far *PhysBasePtr;		/* to flat frame buffer */
	void	far *OffScreenMemOffset;/* to offscreen memory */
	int		OffScreenMemSize;		/* in Kb */
	char	Reserved2[206];

} ModeInfo_t;

int VbeGetVbeInfo(VbeInfo_t far *p)

	/* fetches the vbe info block; returns 0 if no vbe. */
;
int VbeGetModeInfo(int mode,ModeInfo_t far *p)

	/* fetches the mode info block for the specified mode 
	number;	returns 0 if mode unsupported by vbe. */
;
int VbeSetMode(int mode)

	/* initializes the requested video mode; returns 0 if 
	there's no vbe or the mode is unavailable. */
;
void VbeSetPalette(const char far *p,int start,int n)

	/* loads the dac palette registers; uses bios on vbe 
	versions before 2.0 */
;
void VbeSetWindow(int window,int position)

	/* repositions the indicates memory window to the new
	position (in WinGranularity units). */
;
void VbeWrite(int x,int y,int bytes,const char far *buffer)

	/* copies the contents of the buffer (<64k) to display, 
	starting at pixel (x,y). */
;
/*--------------------------------------------------------------
                              eof
--------------------------------------------------------------*/
