Listing 3:
/*--------------------------------------------------------------
  check.c         check.exe entry point               1.0
----------------------------------------------------------------

  Program:	reports current system's VESA VBE capabilities.

  Build:	check.c,vbe.c,vbe.h --> check.exe

  Platform:	IBMPC,MSDOS.

  Functions:  
	main		Display VESA VBE information.
  	ListModes	Display info on VESA Super VGA VideoModePtr.
  	  
  Edit history:
	4/9/96	C.Krehbiel. Implemented check.c in MSVC 1.0 for 
			IBMPC compatible platforms.
			
--------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>

#include <conio.h>

#include "vbe.h"	/* vesa vbe interface */

/*--------------------------------------------------------------
                         local functions			
--------------------------------------------------------------*/
static void ListModes(int far *p)

	/* reports on each of the svga modes on the ModeListPtr (p)
	returned by the vbe. */
{
	static ModeInfo_t info;
	static const char *Text[]=
	{
		"Text mode","CGA graphics","Hercules","Planar",
		"Packed pixel","Planar 256","Direct color","YUV",
		"Unknown"
	};
	
	puts("Mode\tMemory Model\tWinA\tWinB\tWindow\tResolution");
	for(;*p>0;p++)
	{
		if(!VbeGetModeInfo(*p,&info)) continue;

		printf("%3Xh\t",*p);
		printf("%-12.12s\t",
			(info.MemoryModel>7?Text[7]:Text[info.MemoryModel]));
		printf("%04Xh\t",info.WinASegment);
		printf("%04Xh\t",info.WinBSegment);
		printf("%d/%d\t",info.WinGranularity,info.WinSize);
		printf("%dx%dx",info.XResolution,info.YResolution);
		
		if(!(info.ModeAttributes&8)) putchar('1');
		else if(info.BitsPerPixel>16) 
			printf("%dM",1<<info.BitsPerPixel-20);
		else if(info.BitsPerPixel>8) 
			printf("%dK",1<<info.BitsPerPixel-10);
		else printf("%d",1<<info.BitsPerPixel);
		
		if(!(info.ModeAttributes&1)) printf(" (unavailable)");
		
		putchar('\n');
	}
}
void main()

	/* reports on the current vbe implementation and uses 
	ListModes() to report on vesa mode information. */
{
	static VbeInfo_t vbe;

	if(VbeGetVbeInfo(&vbe)) 
	{
		printf("%.4s ",vbe.VbeSignature);
		printf("%d.%d ",
			(vbe.VbeVersion>>8)&0xff,vbe.VbeVersion&0xff);
		printf("%Fs\n",vbe.OemStringPtr);
		if(vbe.TotalMemory<0x10) 
			printf("%dK",vbe.TotalMemory<<6);
		else printf("%dMB",vbe.TotalMemory>>4);
		puts(" video memory installed.");
		
		ListModes(vbe.VideoModePtr);
	}
	else puts("VESA not detected.");

}
/*--------------------------------------------------------------
                               eof
--------------------------------------------------------------*/

