#include "extra.h"

extern char* cd; //current directory

SpettroPlot::SpettroPlot(TWindow* father,ListaSpettri* ls)
{
	parent=father;
	divider=new float[20];
	xticks=new float[20];
	yticks=new float[20];
	colore=new TColor[11];

	divider[0]=19; //length of the vector
	divider[1]=1e5;
	divider[2]=5e4;
	divider[3]=20000;
	divider[4]=10000;
	divider[5]=5000;
	divider[6]=2000;
	divider[7]=1000;
	divider[8]=500;
	divider[9]=200;
	divider[10]=100;
	divider[11]=50;
	divider[12]=20;
	divider[13]=10;
	divider[14]=5;
	divider[15]=2;
	divider[16]=1;
	divider[17]=0.5;
	divider[18]=0.2;
	divider[19]=0.1;

	char *ini_file;
	ini_file=new char[FILE_NAME_LENGTH];
	strcpy(ini_file,cd);
	strcat(ini_file,"\\prisma.ini");
	ifstream f1(ini_file);

	if (f1)
	{
	  char ini_string[20];
	  char num[20];
	  int r,g,b;
	  for (int i=0;i<=10;i++)
	  {
		 sprintf(num,"color%2d",i);
		 GetPrivateProfileString("Color",num,"0 0 0",ini_string,20,ini_file);
		 istrstream ins(ini_string,strlen(ini_string));
		 ins>>r>>g>>b;
		 colore[i]=TColor(r,g,b);
	  }
	}
	else
	{
		colore[0]=TColor::LtRed;
		colore[1]=TColor(255,0,255);  //Magenta
		colore[2]=TColor(0,0,255);    //Blue
		colore[3]=TColor(0,128,0);    //verde militare
		colore[4]=TColor(0,0,128);    //Blue Prussia
		colore[5]=TColor(128,128,128);//grigio
		colore[6]=TColor(255,0,255);  //Magenta
		colore[7]=TColor(0,0,255);    //Blue
		colore[8]=TColor(0,128,0);    //verde militare
		colore[9]=TColor(0,0,128);    //Blue Prussia
		colore[10]=TColor(128,128,128);//grigio
	}
	delete ini_file;

	ls1=ls;
	memset(&tbzoom,0,sizeof(tbzoom));



	//setting the LOGFONT
	lf.lfHeight = 0;
	lf.lfWidth = 0;
	lf.lfEscapement = 0;
	lf.lfOrientation = 0;
	lf.lfWeight = FW_NORMAL;
	lf.lfItalic = 0;
	lf.lfUnderline = 0;
	lf.lfStrikeOut = 0;
	lf.lfCharSet = ANSI_CHARSET;
	lf.lfOutPrecision = OUT_DEFAULT_PRECIS;
	lf.lfClipPrecision = CLIP_DEFAULT_PRECIS;
	lf.lfQuality = PROOF_QUALITY;
	lf.lfPitchAndFamily = VARIABLE_PITCH | FF_ROMAN;
	strcpy(lf.lfFaceName, "Times New Roman");
	fnt1=0;



	if (ls1->NSpettri()>0) this->Parameters();
}

SpettroPlot::~SpettroPlot()
{
  if (fnt1) delete fnt1;
  delete[]	divider;
  delete[]	xticks;
  delete[]	yticks;
  delete[]	colore;
}

void SpettroPlot::GetClientSize(int width,int height)
{
  w=width;
  h=height;
}

ListaSpettri* SpettroPlot::RitornaLista()
{
  return ls1;
}

float SpettroPlot::Xmi()
{
  return xmi;
}

float SpettroPlot::Xma()
{
  return xma;
}

float SpettroPlot::Ymi()
{
  return ymi;
}

float SpettroPlot::Yma()
{
  return yma;
}

ScalaXY SpettroPlot::ReturnScale()
{
	ScalaXY sc;
	sc.sx=sx;
	sc.sy=sy;
	sc.ox=ox;
	sc.oy=oy;
	return sc;
}


void SpettroPlot::Parameters()
{
	if (ls1->NSpettri()==0) return;
	float xmic,xmac,ymic,ymac;   //estremi temporanei
	if (ls1->NSpettri()>0)
	 {
	  xmi=ls1->GiveElement(1)->Xmi();
	  ymi=ls1->GiveElement(1)->Minimo();
	  yma=ls1->GiveElement(1)->Massimo();
	  xma=ls1->GiveElement(1)->Xma();
	  };

	for (int i=2;i<=ls1->NSpettri();i++)
	  {
		 xmic=ls1->GiveElement(i)->Xmi();
		 xmac=ls1->GiveElement(i)->Xma();
		 ymic=ls1->GiveElement(i)->Minimo();
		 ymac=ls1->GiveElement(i)->Massimo();
		 if (xmic<xmi) xmi=xmic;
		 if (xmac>xma) xma=xmac;
		 if (ymic<ymi) ymi=ymic;
		 if (ymac>yma) yma=ymac;
	  };

	lx=xma-xmi;
	ly=yma-ymi;
	ZParameters(xmi,xma,ymi-ly*.1,yma+ly*.1);

}

void SpettroPlot::ZParameters(float a, float b, float c, float d)
{
	xmi=a;
	xma=b;
	ymi=c;
	yma=d;
	lx=xma-xmi;
	ly=yma-ymi;
	if (yma>1e7)
	{parent->MessageBox("Too high intensity!\n reduce the gain\n of the last spectrum",
					 "Overflow",MB_OK|MB_ICONEXCLAMATION);
	 return;}
	Ticks();		// determina la posizione dei tick-marks
}

void SpettroPlot::Ticks()
{
float fst,ftick,rd;

//x tick marks
int i=0;
int nt=0;
do {
  rd=lx/divider[++i];
  nt=floor(rd);}
while ((nt<5)&&(i<divider[0]));
fst=xmi+divider[i];
ftick=floor(fst/divider[i])*divider[i];
for (int j=0;j<19;j++)
  xticks[j+1]=ftick+divider[i]*j;
xticks[0]=nt;

//the same but for y
i=0;
nt=0;
do {
  rd=ly/divider[++i];
  nt=floor(rd);}
while ((nt<5)&&(i<divider[0]));
fst=ymi+divider[i];
ftick=floor(fst/divider[i])*divider[i];
for (j=0;j<19;j++)
  yticks[j+1]=ftick+divider[i]*j;
yticks[0]=nt;
}

void SpettroPlot::Clear()
{
	parent->Invalidate();
}



void SpettroPlot::Axes(TDC *DC)
{
	//set the font height depending on DC
	lf.lfHeight = 22*h/768;

	fnt1=new TFont(&lf);
	TBrush b1(TColor::White);
	TPen p2(TColor::Black);
	DC->SelectObject(p2);
	DC->SelectObject(b1);  //white filling
	DC->SelectObject(*fnt1);

	float wt=w/1.4;
	float ht=h/1.5;
	sx=(wt/lx);          //scale factors
	sy=-(ht/ly);
	ox=xmi-lx*.25;       //origin
	oy=yma+ly*.05;

	DC->Rectangle((xmi-ox)*sx,(yma-oy)*sy,(xma-ox)*sx,(ymi-oy)*sy);

	//x tick marks
	for (int i=1;i<=xticks[0];i++)
	  {DC->MoveTo((xticks[i]-ox)*sx,(ymi-oy)*sy);
		DC->LineTo((xticks[i]-ox)*sx,(ymi+ly/50-oy)*sy);
		DC->MoveTo((xticks[i]-ox)*sx,(yma-oy)*sy);
		DC->LineTo((xticks[i]-ox)*sx,(yma-ly/50-oy)*sy);}
	DC->SetTextAlign(TA_TOP|TA_CENTER);
	for (i=1;i<=xticks[0];i+=2)
		{char tl[20];
		sprintf(tl,"%6.2f",xticks[i]);
		DC->TextOut((xticks[i]-ox)*sx,(ymi-ly/70-oy)*sy,tl);}

	//y tick marks
	for (i=1;i<=yticks[0];i++)
	  {DC->MoveTo((xmi-ox)*sx,(yticks[i]-oy)*sy);
		DC->LineTo((xmi+lx/65-ox)*sx,(yticks[i]-oy)*sy);
		DC->MoveTo((xma-ox)*sx,(yticks[i]-oy)*sy);
		DC->LineTo((xma-lx/65-ox)*sx,(yticks[i]-oy)*sy);}
	DC->SetTextAlign(TA_RIGHT|TA_BOTTOM);
	for (i=1;i<=yticks[0];i+=2)
		{char tl[20];
		sprintf(tl,"%6.1f ",yticks[i]);
		DC->TextOut((xmi-lx/70-ox)*sx,(yticks[i]-oy)*sy,tl);}

	//file captions
	DC->SetTextAlign(TA_TOP|TA_LEFT);
	DC->Rectangle((xmi-ox)*sx,
					  (ymi-oy)*sy+lf.lfHeight*1.9,
					  (xma-ox)*sx,
					  (ymi-oy)*sy+lf.lfHeight*7.2);
	int xcinque=0;
	float ycinque=0;

	for (i=1;i<=MAX_SPECTRA;i++)
		{ char fn[FILE_NAME_LENGTH];
		  if (i==ls1->ReturnMarked()) sprintf(fn," M :");
		  else sprintf(fn,"%2d : ",i);

		  if (ls1->NSpettri()>=i) strncat(fn,ls1->GiveElement(i)->NomeFile(),
											  strlen(ls1->GiveElement(i)->NomeFile()));
		  if (i>5) {xcinque=1; ycinque=lf.lfHeight*5;};

		  col=i;
		  if (i==ls1->ReturnMarked()) col=0;
		  DC->SetTextColor(colore[col]);
		  DC->TextOut((xmi+(lx/2)*xcinque-ox)*sx+lf.lfHeight,
						  (ymi-oy)*sy-ycinque+lf.lfHeight*(i+1),fn);
		};
	DC->SetTextColor(TColor::Black);

}


void SpettroPlot::Plot(TDC *DC)
{
	Axes(DC);

	for (int j=1;j<=ls1->NSpettri();j++)
	{
	  TSize delta(1,1);
	  ncp=ls1->GiveElement(j)->NumCoppie();
	  col=j;
	  if (j==ls1->ReturnMarked()) col=0;
	  TPen p1(colore[col],ls1->ReturnCerchio(j));
	  TPen p2(colore[col],ls1->ReturnPenWidth(j));
	  
	  //find first point
	  px=ls1->GiveElement(j)->Rprimo()->x;
	  py=ls1->GiveElement(j)->Rprimo()->y;
	  p.x=(px-ox)*sx;
	  p.y=(py-oy)*sy;
	  DC->MoveTo(p);
	  PuntaCoppia corrente;

	  switch (ls1->ReturnLineType(j))
	  {
	  case ST_POINT:
	  DC->SelectObject(p1);

		 for (corrente=ls1->GiveElement(j)->Rprimo();
							 corrente!=ls1->GiveElement(j)->Rultimo();
							 corrente=corrente->puntcp)
			{
				px=corrente->x;
				py=corrente->y;
				p.x=(px-ox)*sx;
				p.y=(py-oy)*sy;
				if ((px>=xmi)&&(px<=xma)&&(py>=ymi)&&(py<=yma))
					 DC->Ellipse(p,delta);

			}
		  break;
	  case ST_LINE:
		 DC->SelectObject(p2);
		 int prev=0;
		 for (corrente=ls1->GiveElement(j)->Rprimo();
							 corrente!=ls1->GiveElement(j)->Rultimo();
							 corrente=corrente->puntcp)
			{
				px=corrente->x;
				py=corrente->y;
				p.x=(px-ox)*sx;
				p.y=(py-oy)*sy;
				if ((px>=xmi)&&(px<=xma)&&(py>=ymi)&&(py<=yma))
					 {if (prev==1) DC->LineTo(p); else DC->MoveTo(p);prev=1;}
				else {DC->MoveTo(p);prev=0;}
			}
        break;

	  };  //end switch
	 };  //end for through the list
}

void SpettroPlot::HorLine(TDC *DC,int y)
{
  if ((y>=(yma-oy)*sy)&&(y<=(ymi-oy)*sy))
  {
	DC->MoveTo((xmi-ox)*sx,y);
	DC->LineTo((xma-ox)*sx,y);
  }
}

void SpettroPlot::VerLine(TDC *DC,int x)
{
  if ((x>=(xmi-ox)*sx)&&(x<=(xma-ox)*sx))
  {
	DC->MoveTo(x,(ymi-oy)*sy);
	DC->LineTo(x,(yma-oy)*sy);
  }	
}
