#include "main.h"

char* cd; //current directory

// The application class.
class TApp : public TApplication
{
public:
	TApp(): TApplication() {}
	void InitMainWindow();
};

DEFINE_RESPONSE_TABLE1(TDec,TDecoratedFrame)
	EV_WM_SIZE,
	EV_WM_MOUSEMOVE,
	EV_WM_LBUTTONDOWN,
	EV_WM_RBUTTONDOWN,
	EV_COMMAND(CM_POINTSIZE,CmPointSize),
	EV_COMMAND(CM_MATPARAM,CmMatParam),
	EV_COMMAND(CM_MATOR,CmMatOriginal),
	EV_COMMAND(CM_MATPICK,CmMatPick),
	EV_COMMAND(CM_MATDERIVE,CmMatDerive),
	EV_COMMAND(CM_MATINTEGRATE,CmMatIntegrate),
	EV_COMMAND(CM_MATCONV,CmMatConv),
	EV_COMMAND(CM_MATNOR,CmMatNorma),
	EV_COMMAND(CM_MATINTERP,CmMatInterp),
	EV_COMMAND(CM_MATADD,CmMatAdd),
	EV_COMMAND(CM_MATSUB,CmMatSub),
	EV_COMMAND(CM_MATBS,CmMatBS),
	EV_COMMAND(CM_FILELOAD,CmFileLoad),
	EV_COMMAND(CM_FILEIMPORTVGX,CmFileImportVGX),
	EV_COMMAND(CM_FILENEW,CmFileNew),
	EV_COMMAND(CM_FILESAVEAS,CmFileSaveAs),
	EV_COMMAND(CM_FILEPRINT,CmFilePrint),
	EV_COMMAND(CM_FILEPRINTERSETUP,CmFilePrintSetup),
	EV_COMMAND(CM_FILEUNLOAD,CmFileUnLoad),
	EV_COMMAND(CM_EDITCOPYMETA,CmEditCopyMetaFile),
	EV_COMMAND(CM_EDITCOPYCLIP,CmEditCopyClipboard),
	EV_COMMAND(CM_PLOTZOOM,CmPlotZoom),
	EV_COMMAND(CM_PLOTZOOMOUT,CmPlotZoomOut),
	EV_COMMAND(CM_PLOTRULERS,CmPlotRulers),
	EV_COMMAND(CM_PLOTMARK,CmPlotMark),
	EV_COMMAND(CM_PLOTRELEASE,CmPlotRelease),
	EV_COMMAND(CM_PLOTNAME,CmPlotName),
	EV_COMMAND(CM_PLOTSTYL,CmPlotStyl),
	EV_COMMAND(CM_HELPABOUT,CmHelpAbout),
	EV_COMMAND(CM_HELPCONT,CmHelpContents),
	EV_COMMAND(CM_CONFCOL,CmConfCol),
	EV_COMMAND(CM_CONFPREF,CmConfPref),
	EV_COMMAND_ENABLE(CM_FILELOAD,CmEnableFileLoad),
	EV_COMMAND_ENABLE(CM_FILEIMPORTVGX,CmEnableFileImportVGX),
	EV_COMMAND_ENABLE(CM_FILESAVEAS,CmEnableFileSaveAs),
	EV_COMMAND_ENABLE(CM_FILENEW,CmEnableFileNew),
	EV_COMMAND_ENABLE(CM_FILEPRINT,CmEnableFilePrint),
	EV_COMMAND_ENABLE(CM_FILEUNLOAD,CmEnableFileUnLoad),
	EV_COMMAND_ENABLE(CM_EDITCOPYMETA,CmEnableEditCopyMetaFile),
	EV_COMMAND_ENABLE(CM_EDITCOPYCLIP,CmEnableEditCopyClipboard),
	EV_COMMAND_ENABLE(CM_POINTSIZE,CmEnablePointSize),
	EV_COMMAND_ENABLE(CM_MATPARAM,CmEnableMatParam),
	EV_COMMAND_ENABLE(CM_MATOR,CmEnableMatOriginal),
	EV_COMMAND_ENABLE(CM_MATPICK,CmEnableMatPick),
	EV_COMMAND_ENABLE(CM_MATDERIVE,CmEnableMatDerive),
	EV_COMMAND_ENABLE(CM_MATINTEGRATE,CmEnableMatIntegrate),
	EV_COMMAND_ENABLE(CM_MATCONV,CmEnableMatConv),
	EV_COMMAND_ENABLE(CM_MATNOR,CmEnableMatNorma),
	EV_COMMAND_ENABLE(CM_MATINTERP,CmEnableMatInterp),
	EV_COMMAND_ENABLE(CM_MATADD,CmEnableMatAdd),
	EV_COMMAND_ENABLE(CM_MATSUB,CmEnableMatSub),
	EV_COMMAND_ENABLE(CM_MATBS,CmEnableMatBS),
	EV_COMMAND_ENABLE(CM_PLOTZOOM,CmEnablePlotZoom),
	EV_COMMAND_ENABLE(CM_PLOTZOOMOUT,CmEnablePlotZoomOut),
	EV_COMMAND_ENABLE(CM_PLOTRULERS,CmEnablePlotRulers),
	EV_COMMAND_ENABLE(CM_PLOTMARK,CmEnablePlotMark),
	EV_COMMAND_ENABLE(CM_PLOTRELEASE,CmEnablePlotRelease),
	EV_COMMAND_ENABLE(CM_PLOTNAME,CmEnablePlotName),
END_RESPONSE_TABLE;



///////////////////////////////////////////////////////////
// TDec::TDec()
//
// This is the main window's constructor.
///////////////////////////////////////////////////////////
TDec::TDec(TWindow *parent, const char far *title,TWndw* client,BOOL trackMenSel):
		 TDecoratedFrame(parent, title,client,trackMenSel)
{
	cliente=client;
	cliente->GetFather(this);
	TSeparatorGadget *s1,*s2,*s3,*s4,*s5;
	current_directory=new char[FILE_NAME_LENGTH];
	strcpy(current_directory,"X:\\");
	current_directory[0]='A'+getdisk();
	getcurdir(0,current_directory+3);
	cd=current_directory;
	stx=new char[30];
	sty=new char[30];
	sta=new char[30];
	stg=new char[30];
	stxs=new char[30];
	stys=new char[30];
	strcpy(stx," X= ");
	strcpy(sty," Y= ");
	strcpy(sta," area ");
	strcpy(stg," gain ");
	strcpy(stxs," x-shift ");
	strcpy(stys," y-shift ");
	tx=new TTextGadget(0,TGadget::Recessed,TTextGadget::Left,10,stx);
	ty=new TTextGadget(0,TGadget::Recessed,TTextGadget::Left,10,sty);
	ta=new TTextGadget(0,TGadget::Recessed,TTextGadget::Left,12,sta);
	tg=new TTextGadget(0,TGadget::Recessed,TTextGadget::Left,12,stg);
	txs=new TTextGadget(0,TGadget::Recessed,TTextGadget::Left,12,stxs);
	tys=new TTextGadget(0,TGadget::Recessed,TTextGadget::Left,12,stys);
	tx->WideAsPossible=TRUE;
	ty->WideAsPossible=TRUE;
	ta->WideAsPossible=TRUE;
	tg->WideAsPossible=TRUE;
	txs->WideAsPossible=TRUE;
	tys->WideAsPossible=TRUE;
	s1=new TSeparatorGadget(3);
	s2=new TSeparatorGadget(3);
	s3=new TSeparatorGadget(3);
	s4=new TSeparatorGadget(3);
	s5=new TSeparatorGadget(3);

	AssignMenu("MENU_1");
	// Position and size the window.
	leftbar=new TControlBar(this,TControlBar::Vertical);
	cntrlbar=new TControlBar(this);

	//Add gadgets to the control bar
	cntrlbar->Insert(*tx);
	cntrlbar->Insert(*s1);
	cntrlbar->Insert(*ty);
	cntrlbar->Insert(*s2);
	cntrlbar->Insert(*ta);
	cntrlbar->Insert(*s3);
	cntrlbar->Insert(*tg);
	cntrlbar->Insert(*s4);
	cntrlbar->Insert(*txs);
	cntrlbar->Insert(*s5);
	cntrlbar->Insert(*tys);

   b1=new TButtonGadget(BITMAP_1,CM_FILELOAD);
	leftbar->Insert(*b1);
	b2=new TButtonGadget(BITMAP_2,CM_FILEUNLOAD);
	leftbar->Insert(*b2);
	b3=new TButtonGadget(BITMAP_3,CM_PLOTRULERS);
	leftbar->Insert(*b3);
	b4=new TButtonGadget(BITMAP_4,CM_EDITCOPYCLIP);
	leftbar->Insert(*b4);
	b5=new TButtonGadget(BITMAP_5,CM_MATPARAM);
	leftbar->Insert(*b5);
	b6=new TButtonGadget(BITMAP_6,CM_PLOTSTYL);
	leftbar->Insert(*b6);

	Insert(*cntrlbar,TDecoratedFrame::Top);
	Insert(*leftbar,TDecoratedFrame::Left);

	//Create a new message bar and insert it
	msgbar=new TMessageBar(this);
	msgbar->SetText("Messages");
	Insert(*msgbar,TDecoratedFrame::Bottom);

	Attr.X = 1;
	Attr.Y = 1;
	Attr.W = GetSystemMetrics(SM_CXSCREEN);
	Attr.H = GetSystemMetrics(SM_CYSCREEN);
}

void TDec::CleanupWindow()
{
	delete tx;
	delete ty;
	delete ta;
	delete tg;
	delete txs;
	delete tys;
	delete stx;
	delete sty;
	delete sta;
	delete stg;
	delete stxs;
	delete stys;
	delete b1;
	delete b2;
	delete b3;
	delete b4;
	delete b5;
	delete b6;
	delete cntrlbar;
	delete leftbar;
	delete msgbar;
	delete current_directory;
}

void TDec::EvSize(UINT i,TSize& s)
{
  TDecoratedFrame::EvSize(i,s);
  TRect rc=GetClientRect();
  TSize sz=rc.Size();
  cliente->PostMessage(PM_CHANGESIZE,sz.cx,sz.cy);
}

void TDec::EvLButtonDown(UINT,TPoint &point)
{
if (cliente->ll->NSpettri()>0)
 {
	ScalaXY sc=cliente->pl->ReturnScale();
	float x=sc.ox+(point.x/sc.sx);
	float y=sc.oy+(point.y/sc.sy);
	sprintf(stx," X = %6.2f",x);
	sprintf(sty," Y = %8.1f",y);
	tx->SetText(stx);
	ty->SetText(sty);

 }
}
void TDec::EvRButtonDown(UINT,TPoint&)
{
	msgbar->SetText("Messages");
}

void TDec::EvMouseMove(UINT,TPoint& point)
{
	ScalaXY sc=cliente->pl->ReturnScale();
	float x=sc.ox+(point.x/sc.sx);
	float y=sc.oy+(point.y/sc.sy);
	sprintf(stx," X = %6.2f",x);
	sprintf(sty," Y = %8.1f",y);
	tx->SetText(stx);
	ty->SetText(sty);
}

void TDec::Statistics()
{
 int nm=cliente->ll->ReturnMarked();
 if (nm>0)
 {
	sprintf(sta," area %6.2e",cliente->ll->GiveElement(nm)->Area());
	sprintf(stg," gain %6.3f",cliente->ll->ReturnGain(nm));
	sprintf(stxs," xsh %6.2f",cliente->ll->ReturnXShift(nm));
	sprintf(stys," ysh %6.1f",cliente->ll->ReturnYShift(nm));
	ta->SetText(sta);
	tg->SetText(stg);
	txs->SetText(stxs);
	tys->SetText(stys);
 }
 else
 {
	strcpy(sta," area ");
	strcpy(stg," gain ");
	strcpy(stxs," x-shift ");
	strcpy(stys," y-shift ");
	ta->SetText(sta);
	tg->SetText(stg);
	txs->SetText(stxs);
	tys->SetText(stys);
 }
}

void TDec::CmPointSize()
{
  cliente->PostMessage(CM_POINTSIZE);
}

void TDec::CmFileLoad()
{
  cliente->PostMessage(CM_FILELOAD);
}

void TDec::CmFileImportVGX()
{
  cliente->PostMessage(CM_FILEIMPORTVGX);
}

void TDec::CmFileSaveAs()
{
  cliente->PostMessage(CM_FILESAVEAS);
}


void TDec::CmFileNew()
{
  cliente->PostMessage(CM_FILENEW);
}

void TDec::CmFileUnLoad()
{
  cliente->PostMessage(CM_FILEUNLOAD);
}

void TDec::CmFilePrint()
{
  cliente->PostMessage(CM_FILEPRINT);
}

void TDec::CmFilePrintSetup()
{
  cliente->PostMessage(CM_FILEPRINTERSETUP);
}

void TDec::CmEditCopyMetaFile()
{
  cliente->PostMessage(CM_EDITCOPYMETA);
}

void TDec::CmEditCopyClipboard()
{
  cliente->PostMessage(CM_EDITCOPYCLIP);
}

void TDec::CmMatParam()
{
  cliente->PostMessage(CM_MATPARAM);
}

void TDec::CmMatOriginal()
{
  cliente->PostMessage(CM_MATOR);
}

void TDec::CmMatPick()
{
  cliente->PostMessage(CM_MATPICK);
}

void TDec::CmMatDerive()
{
  cliente->PostMessage(CM_MATDERIVE);
}

void TDec::CmMatIntegrate()
{
  cliente->PostMessage(CM_MATINTEGRATE);
}

void TDec::CmMatConv()
{
  cliente->PostMessage(CM_MATCONV);
}

void TDec::CmMatNorma()
{
  cliente->PostMessage(CM_MATNOR);
}

void TDec::CmMatInterp()
{
  cliente->PostMessage(CM_MATINTERP);
}

void TDec::CmMatAdd()
{
  cliente->PostMessage(CM_MATADD);
}

void TDec::CmMatSub()
{
  cliente->PostMessage(CM_MATSUB);
}

void TDec::CmMatBS()
{
  cliente->PostMessage(CM_MATBS);
}

void TDec::CmPlotZoom()
{
  cliente->PostMessage(CM_PLOTZOOM);
}

void TDec::CmPlotZoomOut()
{
  cliente->PostMessage(CM_PLOTZOOMOUT);
}

void TDec::CmPlotRulers()
{
  cliente->PostMessage(CM_PLOTRULERS);
  msgbar->SetText("Click the mouse-right button to hide the rulers");
}

void TDec::CmPlotMark()
{
  cliente->PostMessage(CM_PLOTMARK);
}

void TDec::CmConfCol()
{
  cliente->PostMessage(CM_CONFCOL);
}

void TDec::CmConfPref()
{
  cliente->PostMessage(CM_CONFPREF);
}


void TDec::CmPlotStyl()
{
  cliente->PostMessage(CM_PLOTSTYL);
}

void TDec::CmPlotRelease()
{
  cliente->PostMessage(CM_PLOTRELEASE);
}

void TDec::CmPlotName()
{
  cliente->PostMessage(CM_PLOTNAME);
}

void TDec::CmHelpAbout()
{
  cliente->MessageBox("PRISMA version 2.0\n by Gualtiero Chiaia\n e-mail chiaia@axp7000.cdc.polimi.it",
								"About Prisma",MB_OK|MB_ICONASTERISK);
}

void TDec::CmHelpContents()
{
  TWndw help(0,0);
  char* help_file;
  help_file=new char[FILE_NAME_LENGTH];
  strcpy(help_file,current_directory);
  help.WinHelp(strcat(help_file,"\\prisma.hlp"),HELP_CONTENTS,0L);
  delete help_file;
}
void TDec::CmEnableFileLoad(TCommandEnabler &ce)
{
	ce.Enable(cliente->ll->NSpettri()<MAX_SPECTRA);
}

void TDec::CmEnableFileImportVGX(TCommandEnabler &ce)
{
	ce.Enable(cliente->ll->NSpettri()<MAX_SPECTRA);
}

void TDec::CmEnableFileSaveAs(TCommandEnabler &ce)
{
	ce.Enable(cliente->ll->NSpettri()>0);
}

void TDec::CmEnableFileUnLoad(TCommandEnabler &ce)
{
	ce.Enable(cliente->ll->NSpettri()>0);
}

void TDec::CmEnableFileNew(TCommandEnabler &ce)
{
	ce.Enable(cliente->ll->NSpettri()>0);
}

void TDec::CmEnableFilePrint(TCommandEnabler &ce)
{
	ce.Enable(cliente->ll->NSpettri()>0);
}

void TDec::CmEnableEditCopyMetaFile(TCommandEnabler &ce)
{
	ce.Enable(cliente->ll->NSpettri()>0);
}

void TDec::CmEnableEditCopyClipboard(TCommandEnabler &ce)
{
	ce.Enable(cliente->ll->NSpettri()>0);
}

void TDec::CmEnablePlotZoom(TCommandEnabler &ce)
{
	ce.Enable(cliente->ll->NSpettri()>0);
}

void TDec::CmEnablePlotZoomOut(TCommandEnabler &ce)
{
	ce.Enable(cliente->fl_original);
}

void TDec::CmEnablePlotRulers(TCommandEnabler &ce)
{
	ce.Enable((cliente->ll->NSpettri()>0)&&(cliente->rulers==FALSE));
}

void TDec::CmEnablePlotName(TCommandEnabler &ce)
{
	ce.Enable(cliente->ll->NSpettri()>0);
}


void TDec::CmEnablePointSize(TCommandEnabler &ce)
{
	ce.Enable(cliente->ll->NSpettri()>0);
}

void TDec::CmEnablePlotMark(TCommandEnabler &ce)
{
	ce.Enable(cliente->ll->NSpettri()>0);
}

void TDec::CmEnablePlotRelease(TCommandEnabler &ce)
{
	ce.Enable(cliente->ll->ReturnMarked()>0);
}

void TDec::CmEnableMatParam(TCommandEnabler &ce)
{
	ce.Enable(cliente->ll->NSpettri()>0);
}

void TDec::CmEnableMatOriginal(TCommandEnabler &ce)
{
	ce.Enable(cliente->ll->NSpettri()>0);
}

void TDec::CmEnableMatPick(TCommandEnabler &ce)
{
	ce.Enable((cliente->ll->NSpettri()>0)&&(cliente->ll->NSpettri()<10));
}

void TDec::CmEnableMatDerive(TCommandEnabler &ce)
{
	ce.Enable((cliente->ll->NSpettri()>0)&&(cliente->ll->NSpettri()<10));
}

void TDec::CmEnableMatIntegrate(TCommandEnabler &ce)
{
	ce.Enable((cliente->ll->NSpettri()>0)&&(cliente->ll->NSpettri()<10));
}

void TDec::CmEnableMatConv(TCommandEnabler &ce)
{
	ce.Enable((cliente->ll->NSpettri()>0)&&(cliente->ll->NSpettri()<10));
}

void TDec::CmEnableMatNorma(TCommandEnabler &ce)
{
	ce.Enable(cliente->ll->NSpettri()>1);
}

void TDec::CmEnableMatInterp(TCommandEnabler &ce)
{
	ce.Enable((cliente->ll->NSpettri()>0)&&(cliente->ll->NSpettri()<10));
}

void TDec::CmEnableMatAdd(TCommandEnabler &ce)
{
	ce.Enable((cliente->ll->NSpettri()>1)&&(cliente->ll->NSpettri()<10));
}

void TDec::CmEnableMatSub(TCommandEnabler &ce)
{
	ce.Enable((cliente->ll->NSpettri()>1)&&(cliente->ll->NSpettri()<10));
}

void TDec::CmEnableMatBS(TCommandEnabler &ce)
{
	ce.Enable((cliente->ll->NSpettri()>0)&&(cliente->ll->NSpettri()<10));
}


///////////////////////////////////////////////////////////
// TApp::InitMainWindow()
//
// This function creates the application's main window.
///////////////////////////////////////////////////////////
void TApp::InitMainWindow()
{
	TWndw *client=new TWndw(0,0); //the client window
	TDecoratedFrame *wndw = new TDec(0, "Prisma",client,TRUE);
	wndw->SetIcon(this,ICON_1);
	SetMainWindow(wndw);
	EnableBWCC();
	EnableCtl3d();
}

///////////////////////////////////////////////////////////
// OwlMain()
///////////////////////////////////////////////////////////
int OwlMain(int, char*[])
{
	return TApp().Run();
}




