# include "main.h"

extern char *cd; //current directory

DEFINE_RESPONSE_TABLE1(TWndw, TWindow)
	EV_WM_LBUTTONDOWN,
	EV_WM_RBUTTONDOWN,
	EV_WM_MOUSEMOVE,
	EV_MESSAGE(PM_CHANGESIZE,MsSize),
	EV_MESSAGE(CM_POINTSIZE,MsPointSize),
	EV_MESSAGE(CM_MATPARAM,MsMatParam),
	EV_MESSAGE(CM_MATOR,MsMatOriginal),
	EV_MESSAGE(CM_MATPICK,MsMatPick),
	EV_MESSAGE(CM_MATDERIVE,MsMatDerive),
	EV_MESSAGE(CM_MATINTEGRATE,MsMatIntegrate),
	EV_MESSAGE(CM_MATCONV,MsMatConv),
	EV_MESSAGE(CM_MATNOR,MsMatNorma),
	EV_MESSAGE(CM_MATINTERP,MsMatInterp),
	EV_MESSAGE(CM_MATADD,MsMatAdd),
	EV_MESSAGE(CM_MATSUB,MsMatSub),
	EV_MESSAGE(CM_MATBS,MsMatBS),
	EV_MESSAGE(CM_FILELOAD,MsFileLoad),
	EV_MESSAGE(CM_FILEIMPORTVGX,MsFileImportVGX),	
	EV_MESSAGE(CM_FILESAVEAS,MsFileSaveAs),
	EV_MESSAGE(CM_FILENEW,MsFileNew),
	EV_MESSAGE(CM_FILEPRINT,MsFilePrint),
	EV_MESSAGE(CM_FILEPRINTERSETUP,MsFilePrintSetup),
	EV_MESSAGE(CM_FILEUNLOAD,MsFileUnLoad),
	EV_MESSAGE(CM_EDITCOPYMETA,MsEditCopyMetaFile),
	EV_MESSAGE(CM_EDITCOPYCLIP,MsEditCopyClipboard),
	EV_MESSAGE(CM_PLOTZOOM,MsPlotZoom),
	EV_MESSAGE(CM_PLOTRULERS,MsPlotRulers),
	EV_MESSAGE(CM_PLOTZOOMOUT,MsPlotZoomOut),
	EV_MESSAGE(CM_PLOTMARK,MsPlotMark),
	EV_MESSAGE(CM_PLOTNAME,MsPlotName),
	EV_MESSAGE(CM_PLOTSTYL,MsPlotStyl),
	EV_MESSAGE(CM_PLOTRELEASE,MsPlotRelease),
	EV_MESSAGE(CM_CONFCOL,MsConfCol),
	EV_MESSAGE(CM_CONFPREF,MsConfPref),
END_RESPONSE_TABLE;


///////////////////////////////////////////////////////////
// TWndw::TWndw()
//
// This is the client window's constructor.
///////////////////////////////////////////////////////////
TWndw::TWndw(TWindow *parent, const char far *title):
		 TWindow(parent, title)
 {
  padre=0;
  rulers=FALSE;
  }



void TWndw::SetupWindow()
{
	printer=new TPrinter;
	ll=new ListaSpettri(this);
	pl=new SpettroPlot(this,ll);
	fl_original=FALSE; // nessun cambiamento alle dimensioni dello spettro


}

void TWndw::CleanupWindow()
{
 delete printer;
 delete ll;
 delete pl;

}

BOOL TWndw::CanClose()
{

	char ini_file[FILE_NAME_LENGTH];
	char out_string[30];
	char num[20];
	strcpy(ini_file,cd);
	strcat(ini_file,"\\prisma.ini");
	WritePrivateProfileString(NULL,NULL,NULL,ini_file); //flushes

	for (int i=0;i<=10;i++)
	  {
		 sprintf(num,"color%2d",i);
		 sprintf(out_string," %3d %3d %3d ",pl->colore[i].Red(),
					pl->colore[i].Green(),pl->colore[i].Blue());
		 WritePrivateProfileString("Color",num,out_string,ini_file);
	  }
	sprintf(out_string," %3d %3d",ll->lth,ll->pth);
	WritePrivateProfileString("Preferences","l/p th",out_string,ini_file);
	if (ll->pref_style==ST_POINT)strcpy(out_string,"0");
	else strcpy(out_string,"1");
	WritePrivateProfileString("Preferences","l/p style",out_string,ini_file);
	WritePrivateProfileString("Preferences","workdir",cd,ini_file);

	return TRUE;
}

char far* TWndw::GetClassName()   //name for the modified window class
{
  return "SpectraWindow";
}

void TWndw::GetWindowClass(WNDCLASS &wndclass)
{
	TWindow::GetWindowClass(wndclass);  //default settings

	//change cursor
	wndclass.hCursor=LoadCursor(0,IDC_CROSS);
}

void TWndw::GetFather(TDec* father)
{
  padre=father;
}

void TWndw::Paint(TDC &pDC,BOOL,TRect&)
{
	if (pl->RitornaLista()->NSpettri()>0) pl->Plot(&pDC);
}

LRESULT TWndw::MsSize(WPARAM w,LPARAM h)
{
	pl->GetClientSize(int(w),int(h));
	if (pl->RitornaLista()->NSpettri()>0) pl->Clear();      //manda un Invalidate alla finestra ->Paint()
	return 1;
}

void TWndw::EvLButtonDown(UINT,TPoint&)
{
  padre->ForwardMessage();
}

void TWndw::EvRButtonDown(UINT,TPoint&)
{
  if (rulers)
  {
	 rulers=FALSE;
	 delete cdc;
	 pl->Clear();
	 padre->ForwardMessage();
  }
}

void TWndw::EvMouseMove(UINT,TPoint& point)
{
  if (rulers)
  {
	 cdc->SetROP2(R2_XORPEN);

	 //draw new rulers
	 pl->HorLine(cdc,point.y);
	 pl->VerLine(cdc,point.x);

	 //cancel previous rulers
	 pl->HorLine(cdc,ruly);
	 pl->VerLine(cdc,rulx);


	 rulx=point.x;
	 ruly=point.y;
	 padre->ForwardMessage();
  }
}




LRESULT TWndw::MsFileLoad(WPARAM,LPARAM)
{
	FileDataOpen=new TOpenSaveDialog::TData (OFN_FILEMUSTEXIST|
								OFN_HIDEREADONLY|OFN_PATHMUSTEXIST|OFN_ALLOWMULTISELECT,
		"All Files (*.*)|*.*|Text Files (*.txt)|*.txt",0, 0, 0);
	char *tk,fn[30],tfn[150];
	ofd = new TFileOpenDialog(this,*FileDataOpen);
	ofd->SetCaption("Load file");
	int result=ofd->Execute();
	if (result==IDOK)
	{
		 if (strstr(FileDataOpen->FileName," "))  //multiple selection
		 {
			 strcpy(tfn,FileDataOpen->FileName);
			 strtok(tfn," ");
			 while (tk=strtok(NULL," "))
			 {
				strcpy(fn,tfn);
				strcat(fn,"\\");
				strcat(fn,tk);
				if (ll->NSpettri()<10) ll->CaricaSpettro(fn);
			 }
		 }
		 else ll->CaricaSpettro(FileDataOpen->FileName); //single selection
		 pl->Parameters();
		 sprintf(pl->tbzoom.sbxmin,"%6.2f",pl->Xmi());
		 sprintf(pl->tbzoom.sbxmax,"%6.2f",pl->Xma());
		 sprintf(pl->tbzoom.sbymin,"%8.1f",pl->Ymi());
		 sprintf(pl->tbzoom.sbymax,"%8.1f",pl->Yma());
		 pl->Clear();
	 }
	 delete ofd;
	 delete FileDataOpen;
	 return 1;
}

LRESULT TWndw::MsFileImportVGX(WPARAM,LPARAM)
{
	FileDataOpen=new TOpenSaveDialog::TData (OFN_FILEMUSTEXIST|
								OFN_HIDEREADONLY|OFN_PATHMUSTEXIST|OFN_ALLOWMULTISELECT,
		"All Files (*.*)|*.*|Text Files (*.txt)|*.txt",0, 0, 0);
	ofd = new TFileOpenDialog(this,*FileDataOpen);
	ofd->SetCaption("Import file VGX900");
	int result=ofd->Execute();
	if (result==IDOK)
	{
		 ll->CaricaSpettro(FileDataOpen->FileName,1);
		 pl->Parameters();
		 sprintf(pl->tbzoom.sbxmin,"%6.2f",pl->Xmi());
		 sprintf(pl->tbzoom.sbxmax,"%6.2f",pl->Xma());
		 sprintf(pl->tbzoom.sbymin,"%8.1f",pl->Ymi());
		 sprintf(pl->tbzoom.sbymax,"%8.1f",pl->Yma());
		 pl->Clear();
	 }
	 delete ofd;
	 delete FileDataOpen;
	 return 1;
}


LRESULT TWndw::MsFileSaveAs(WPARAM,LPARAM)
{
  FileDataSave=new TOpenSaveDialog::TData (OFN_OVERWRITEPROMPT|OFN_HIDEREADONLY,
	  "All Files (*.*)|*.*|Text Files (*.txt)|*.txt",
		0, 0, "TXT");
//salto la scelta-spettro se ho un solo spettro o e' gia' selezionato
  int ns=ll->ReturnMarked();
  if ((pl->RitornaLista()->NSpettri()>1)&&(ns==0)) ns=this->SelectSpectrum();
  else if (ns==0) ns=1;  //se e' vera significa che ho un solo spettro
  if ((ns>0)&&(ns<=pl->RitornaLista()->NSpettri()))
  {	sfd = new TFileSaveDialog(this,*FileDataSave);
		sfd->SetCaption("Save Spectrum");
		int result=sfd->Execute();
		if (result==IDOK)
			ll->GiveElement(ns)->SalvaFile(FileDataSave->FileName);
		delete sfd;
  }
  delete FileDataSave;
  return 1;
}

LRESULT TWndw::MsFileUnLoad(WPARAM,LPARAM)
{
  int ns=1;
  if (pl->RitornaLista()->NSpettri()>1) ns=this->SelectSpectrum();
  pl->RitornaLista()->ScaricaSpettro(ns);
  pl->Parameters();
  pl->Clear();
  padre->Statistics();
  return 1;
}


LRESULT TWndw::MsFilePrint(WPARAM,LPARAM)
{
  if (printer)
	 {TWndwPrintout printout("Prisma", this);
	  printer->Print(this,printout,TRUE);}
  return 1;
}


LRESULT TWndw::MsFileNew(WPARAM,LPARAM)
{
  ll->Svuota();
  pl->Parameters();
  pl->Clear();
  padre->Statistics();
  return 1;
}

LRESULT TWndw::MsFilePrintSetup(WPARAM,LPARAM)
{
  if (printer)
	 printer->Setup(this);
  return 1;
}

LRESULT TWndw::MsEditCopyMetaFile(WPARAM,LPARAM)
{
	FileDataMeta=new TOpenSaveDialog::TData (OFN_OVERWRITEPROMPT|OFN_HIDEREADONLY,
	  "Windows metafiles (*.wmf)|*.wmf",
		0, 0, "wmf");
	smeta = new TFileSaveDialog(this,*FileDataMeta);
	smeta->SetCaption("Save Metafile");
	int result=smeta->Execute();
	if (result==IDOK)
	{

	  TMetaFileDC* meta=new TMetaFileDC(FileDataMeta->FileName);
		meta->SetMapMode(MM_TEXT);
		TRect rect=GetClientRect();
		meta->SetWindowExt(rect.Size());
		TSize ss(2400,2400);
		meta->SetViewportExt(ss);
		this->Paint(*meta,FALSE,rect);
		meta->Close();
		delete meta;
	}
	delete smeta;
	delete FileDataMeta;
	return 1;
}

LRESULT TWndw::MsEditCopyClipboard(WPARAM,LPARAM)
{
	char* meta_file;
	meta_file=new char[FILE_NAME_LENGTH];
	strcpy(meta_file,padre->current_directory);
	strcat(meta_file,"\\prisma.wmf");
	TMetaFileDC* meta=new TMetaFileDC(meta_file);
	meta->SetMapMode(MM_TEXT);
	TRect rect=GetClientRect();
	meta->SetWindowExt(rect.Size());
	TSize ss(2400,2400);
	meta->SetViewportExt(ss);
	this->Paint(*meta,FALSE,rect);
	TMetaFilePict* mfp=new TMetaFilePict(meta->Close());

	TClipboard &clip=OpenClipboard();  //TWindow &OpenClipboard memb. funct.
	clip.EmptyClipboard();
	clip<<*mfp;
	clip.CloseClipboard();
	delete meta;
	delete mfp;
	delete meta_file;
	return 1;
}

LRESULT TWndw::MsPointSize(WPARAM,LPARAM)
{
//salto la scelta-spettro se ho un solo spettro o e' gia' selezionato
  int ns=ll->ReturnMarked();
  if ((pl->RitornaLista()->NSpettri()>1)&&(ns==0)) ns=this->SelectSpectrum();
  else if (ns==0) ns=1;  //se e' vera significa che ho un solo spettro
  TDialog* dia=new TDlg(this,DIALOG_1);
  if ((ns>0)&&(ns<=pl->RitornaLista()->NSpettri()))
  {
	 int result=dia->Execute();
	 if  (result==IDOK)
	 {
			ll->SetCerchio(ns,atoi(ll->sbt));
			pl->Clear();
	 }
	 delete dia;
  }
  return 1;
}



LRESULT TWndw::MsMatParam(WPARAM,LPARAM)
{

//salto la scelta-spettro se ho un solo spettro o e' gia' selezionato
  int ns=ll->ReturnMarked();
  if ((pl->RitornaLista()->NSpettri()>1)&&(ns==0)) ns=this->SelectSpectrum();
  else if (ns==0) ns=1;

  TDlg* dia2=new TDlg(this,DIALOG_5,ns);
  sprintf(dia2->tbpar.sbgain,"%7.3f",float(1));
  sprintf(dia2->tbpar.sbxshift,"%6.2f",float(0));
  sprintf(dia2->tbpar.sbyshift,"%8.1f",float(0));
  if ((ns>0)&&(ns<=pl->RitornaLista()->NSpettri()))
	 {
		if (pl->RitornaLista()->ReturnXSign(ns)==1)
						{dia2->tbpar.radio1=TRUE;dia2->tbpar.radio2=FALSE;}
		else  {dia2->tbpar.radio2=TRUE;dia2->tbpar.radio1=FALSE;}

		int result2=dia2->Execute();
		if  (result2==IDOK)
		{
			float tg=atof(dia2->tbpar.sbgain);
			float txsh=atof(dia2->tbpar.sbxshift);
			float tysh=atof(dia2->tbpar.sbyshift);
			int txsg;
			if (dia2->tbpar.radio1==TRUE) txsg=1;
			else txsg=-1;
			if (txsg!=pl->RitornaLista()->ReturnXSign(ns))
				 pl->RitornaLista()->GiveElement(ns)->XSign();
			pl->RitornaLista()->GiveElement(ns)->YShift(tysh);
			pl->RitornaLista()->GiveElement(ns)->Gain(tg);
			pl->RitornaLista()->GiveElement(ns)->XShift(txsh);
			pl->RitornaLista()->CaricaSGS(ns,tg,txsh,tysh,txsg);
			pl->Parameters();
			pl->Clear();
			padre->Statistics();
			sprintf(pl->tbzoom.sbxmin,"%6.2f",pl->Xmi());
			sprintf(pl->tbzoom.sbxmax,"%6.2f",pl->Xma());
			sprintf(pl->tbzoom.sbymin,"%8.1f",pl->Ymi());
			sprintf(pl->tbzoom.sbymax,"%8.1f",pl->Yma());
		}
	 }
  delete dia2;
  return 1;
}



LRESULT TWndw::MsMatOriginal(WPARAM,LPARAM)
{
//salto la scelta-spettro se ho un solo spettro o e' gia' selezionato
  int ns=ll->ReturnMarked();
  if ((pl->RitornaLista()->NSpettri()>1)&&(ns==0)) ns=this->SelectSpectrum();
  else if (ns==0) ns=1;  //se e' vera significa che ho un solo spettro

  if ((ns>0)&&(ns<=pl->RitornaLista()->NSpettri()))
	 {
		pl->RitornaLista()->RicaricaSpettro(ns);
		pl->Parameters();
		pl->Clear();
		padre->Statistics();
		sprintf(pl->tbzoom.sbxmin,"%6.2f",pl->Xmi());
		sprintf(pl->tbzoom.sbxmax,"%6.2f",pl->Xma());
		sprintf(pl->tbzoom.sbymin,"%8.1f",pl->Ymi());
		sprintf(pl->tbzoom.sbymax,"%8.1f",pl->Yma());
	 }
  return 1;
}

LRESULT TWndw::MsMatPick(WPARAM,LPARAM)
{
//salto la scelta-spettro se ho un solo spettro o e' gia' selezionato
  int ns=ll->ReturnMarked();
  if ((pl->RitornaLista()->NSpettri()>1)&&(ns==0)) ns=this->SelectSpectrum();
  else if (ns==0) ns=1;  //se e' vera significa che ho un solo spettro

  TDlg* dia=new TDlg(this,DIALOG_7);
  float lf,rg;

  if ((ns>0)&&(ns<=pl->RitornaLista()->NSpettri()))
	 {
		sprintf(dia->tbpick.sb_left,"%6.2f",ll->GiveElement(ns)->Xmi());
		sprintf(dia->tbpick.sb_right,"%6.2f",ll->GiveElement(ns)->Xma());
		int result=dia->Execute();
		if  (result==IDOK)
		{
		 lf=atof(dia->tbpick.sb_left);
		 rg=atof(dia->tbpick.sb_right);
		 char *nm;
		 nm=new char[FILE_NAME_LENGTH];
		 SpettroFile* old=new SpettroFile(*ll->GiveElement(ns));   //save original
		 ll->GiveElement(ns)->Pick(lf,rg);

		 ll->ReplicaSpettro(ns);                  //append picked
		 sprintf(nm,"Picked from # %2d",ns);
		 ll->GiveElement(ll->NSpettri())->CambiaNome(nm);   //change name
		 ll->PutElement(ns,*old);

		 pl->Parameters();
		 pl->Clear();
		 delete old;
		}
	 }
  delete dia;
  return 1;
}

LRESULT TWndw::MsMatDerive(WPARAM,LPARAM)
{
//salto la scelta-spettro se ho un solo spettro o e' gia' selezionato
  int ns=ll->ReturnMarked();
  if ((pl->RitornaLista()->NSpettri()>1)&&(ns==0)) ns=this->SelectSpectrum();
  else if (ns==0) ns=1;  //se e' vera significa che ho un solo spettro

  if ((ns>0)&&(ns<=pl->RitornaLista()->NSpettri()))
	 {
		 char *nm;
		 nm=new char[FILE_NAME_LENGTH];
		 SpettroFile* old=new SpettroFile(*ll->GiveElement(ns));   //save original
		 ll->GiveElement(ns)->Derive();

		 ll->ReplicaSpettro(ns);                  //append picked
		 sprintf(nm,"Derivative of # %2d",ns);
		 ll->GiveElement(ll->NSpettri())->CambiaNome(nm);   //change name
		 ll->PutElement(ns,*old);

		 pl->Parameters();
		 pl->Clear();
		 delete old;
		}
  return 1;
}

LRESULT TWndw::MsMatIntegrate(WPARAM,LPARAM)
{
 //salto la scelta-spettro se ho un solo spettro o e' gia' selezionato
  int ns=ll->ReturnMarked();
  if ((pl->RitornaLista()->NSpettri()>1)&&(ns==0)) ns=this->SelectSpectrum();
  else if (ns==0) ns=1;  //se e' vera significa che ho un solo spettro

  if ((ns>0)&&(ns<=pl->RitornaLista()->NSpettri()))
	 {
		 char *nm;
		 nm=new char[FILE_NAME_LENGTH];
		 SpettroFile* old=new SpettroFile(*ll->GiveElement(ns));   //save original
		 ll->GiveElement(ns)->Integrate();

		 ll->ReplicaSpettro(ns);                  //append picked
		 sprintf(nm,"Integral of # %2d",ns);
		 ll->GiveElement(ll->NSpettri())->CambiaNome(nm);   //change name
		 ll->PutElement(ns,*old);

		 pl->Parameters();
		 pl->Clear();
		 delete old;
		}
  return 1;
}

LRESULT TWndw::MsMatConv(WPARAM,LPARAM)
{
//salto la scelta-spettro se ho un solo spettro o e' gia' selezionato
  float gw=0;
  float gl=0;
  int ns=ll->ReturnMarked();
  if ((pl->RitornaLista()->NSpettri()>1)&&(ns==0)) ns=this->SelectSpectrum();
  else if (ns==0) ns=1;  //se e' vera significa che ho un solo spettro

  TDlg* dia=new TDlg(this,DIALOG_2);
  if ((ns>0)&&(ns<=pl->RitornaLista()->NSpettri()))
	 {
		int result=dia->Execute();
		if  (result==IDOK)
		{
		 if (dia->tbconv.check_g==TRUE) gw=atof(dia->tbconv.sb_g);
		 if (dia->tbconv.check_l==TRUE) gl=atof(dia->tbconv.sb_l);
		 char *nm;
		 nm=new char[FILE_NAME_LENGTH];
		 SpettroFile* old=new SpettroFile(*ll->GiveElement(ns));   //save original
		 int res=ll->GiveElement(ns)->Convolution(gw,gl);   //convolute

		 BOOL flag=TRUE;
		 if (((res==1)&&(dia->tbconv.check_l==TRUE))||
			  ((res==0)&&(dia->tbconv.check_l==TRUE)&&(dia->tbconv.check_g==FALSE)))
			{MessageBox("Too high or too low FWHM\n in Lorentzian convolution",
					 "Convolution",MB_OK|MB_ICONEXCLAMATION);
			 flag=FALSE;}

		 if (((res==2)&&(dia->tbconv.check_g==TRUE))||
			  ((res==0)&&(dia->tbconv.check_l==FALSE)&&(dia->tbconv.check_g==TRUE)))
			{MessageBox("Too high or too low FWHM\n in Gaussian convolution",
					  "Convolution",MB_OK|MB_ICONEXCLAMATION);
			 flag=FALSE;}

		 if ((res==0)&&(dia->tbconv.check_l==TRUE)&&(dia->tbconv.check_g==TRUE))
			{MessageBox("Problem with both convolutions","Convolution",MB_OK|MB_ICONEXCLAMATION);
			 flag=FALSE;}

		 if ((flag)&&(res>0))
			{
			  ll->ReplicaSpettro(ns);                  //append convoluted
			  sprintf(nm,"Convolution of # %2d",ns);
			  ll->GiveElement(ll->NSpettri())->CambiaNome(nm);   //change name
			  ll->PutElement(ns,*old);                       //restore old

			  pl->Parameters();
			  pl->Clear();
			}

		 delete old;
		}
	 }
  delete dia;
  return 1;
}


LRESULT TWndw::MsMatNorma(WPARAM,LPARAM)
{
  int n1,n2,i,flr;
  char s1[FILE_NAME_LENGTH],s2[FILE_NAME_LENGTH];
  n1=0;
  n2=0;
  TDlg* dia3=new TDlg(this,DIALOG_6);
  int result=dia3->Execute();
  if  (result==IDOK)
  {
	dia3->tbnor.lbd1.GetSelString(s1,sizeof(s1));
	dia3->tbnor.lbd2.GetSelString(s2,sizeof(s2));
	for (i=1;i<=ll->NSpettri();i++)
			{flr=strcmp(s1,ll->GiveElement(i)->NomeFile());
			if (flr==0) n1=i;}
	for (i=1;i<=ll->NSpettri();i++)
			{flr=strcmp(s2,ll->GiveElement(i)->NomeFile());
			if (flr==0) n2=i;}
	if ((dia3->tbnor.radio_1==TRUE)&&(n1>0)&&(n2>0))
		{float ys1=ll->GiveElement(n1)->Minimo();
		 float ys2=ll->GiveElement(n2)->Minimo();
		 ll->GiveElement(n1)->YShift(-ys1);
		 ll->GiveElement(n2)->YShift(-ys2);
		 float nor_factor=ll->GiveElement(n1)->Norma(*(ll->GiveElement(n2)));
		 ll->CaricaSGS(n1,nor_factor,0,-ys1,ll->ReturnXSign(n1));
		 ll->CaricaSGS(n2,1,0,-ys2,ll->ReturnXSign(n2));
		 pl->Parameters();
		 pl->Clear();
		 padre->Statistics();}
	else if ((dia3->tbnor.radio_2==TRUE)&&(n1>0)&&(n2>0))
		{float ys1=ll->GiveElement(n1)->Minimo();
		 float ys2=ll->GiveElement(n2)->Minimo();
		 ll->GiveElement(n1)->YShift(-ys1);
		 ll->GiveElement(n2)->YShift(-ys2);
		 float nor_factor=ll->GiveElement(n1)->NormArea(*(ll->GiveElement(n2)));
		 ll->CaricaSGS(n1,nor_factor,0,-ys1,ll->ReturnXSign(n1));
		 ll->CaricaSGS(n2,1,0,-ys2,ll->ReturnXSign(n2));
		 pl->Parameters();
		 pl->Clear();
		 padre->Statistics();}
	else if ((dia3->tbnor.radio_3==TRUE)&&(n1>0)&&(n2>0))
		{float p=atof(dia3->tbnor.sb_3);
		 float ys1=ll->GiveElement(n1)->Minimo();
		 float ys2=ll->GiveElement(n2)->Minimo();
		 ll->GiveElement(n1)->YShift(-ys1);
		 ll->GiveElement(n2)->YShift(-ys2);
		 float nor_factor=ll->GiveElement(n1)->NormaPoint(*(ll->GiveElement(n2)),p);
		 ll->CaricaSGS(n1,nor_factor,0,-ys1,ll->ReturnXSign(n1));
		 ll->CaricaSGS(n2,1,0,-ys2,ll->ReturnXSign(n2));
		 pl->Parameters();
		 pl->Clear();
		 padre->Statistics();}
  }
  delete dia3;
  return 1;
}

LRESULT TWndw::MsMatInterp(WPARAM,LPARAM)
{
//salto la scelta-spettro se ho un solo spettro o e' gia' selezionato
  int ns=ll->ReturnMarked();
  if ((pl->RitornaLista()->NSpettri()>1)&&(ns==0)) ns=this->SelectSpectrum();
  else if (ns==0) ns=1;  //se e' vera significa che ho un solo spettro

  TDlg* dia=new TDlg(this,DIALOG_8);
  float lf,st,rg;
  int tipo=0;

  if ((ns>0)&&(ns<=pl->RitornaLista()->NSpettri()))
	 {
		sprintf(dia->tbint.sb_left,"%6.2f",ll->GiveElement(ns)->Xmi());
		sprintf(dia->tbint.sb_step,"%6.3f",
					(ll->GiveElement(ns)->TrovaX(2)-ll->GiveElement(ns)->TrovaX(1)));
		sprintf(dia->tbint.sb_right,"%6.2f",ll->GiveElement(ns)->Xma());
		int result=dia->Execute();
		if  (result==IDOK)
		{
		 lf=atof(dia->tbint.sb_left);
		 st=atof(dia->tbint.sb_step);
		 rg=atof(dia->tbint.sb_right);
		 if (dia->tbint.radio_splin==TRUE) tipo=1;
		 char *nm;
		 nm=new char[FILE_NAME_LENGTH];
		 SpettroFile* old=new SpettroFile(*ll->GiveElement(ns));   //save original
		 int res=ll->GiveElement(ns)->Interpolate(tipo,lf,st,rg);
		 if (res==0)
			MessageBox("Error in the chosen extrema,\n or in the step",
						  "Interpolation Error",MB_OK|MB_ICONEXCLAMATION);
		 else if (res==1)
			MessageBox("Step too narrow",
						  "Interpolation Error",MB_OK|MB_ICONEXCLAMATION);
		 else
			{
			 ll->ReplicaSpettro(ns);                  //append picked
			 sprintf(nm,"Interpolated from # %2d",ns);
			 ll->GiveElement(ll->NSpettri())->CambiaNome(nm);   //change name
			 ll->PutElement(ns,*old);                          //restore old
			 pl->Parameters();
			 pl->Clear();
			}
		 delete old;
		}
	 }
  delete dia;
  return 1;
}

LRESULT TWndw::MsMatAdd(WPARAM,LPARAM)
{
  int n1,n2,i,flr;
  char s1[FILE_NAME_LENGTH],s2[FILE_NAME_LENGTH];
  n1=0;
  n2=0;
  TDlg* dia3=new TDlg(this,DIALOG_9);
  dia3->SetCaption("Add");
  int result=dia3->Execute();
  if  (result==IDOK)
  {
	dia3->tbadsu.lbd1.GetSelString(s1,sizeof(s1));
	dia3->tbadsu.lbd2.GetSelString(s2,sizeof(s2));
	for (i=1;i<=ll->NSpettri();i++)
			{flr=strcmp(s1,ll->GiveElement(i)->NomeFile());
			if (flr==0) n1=i;}
	for (i=1;i<=ll->NSpettri();i++)
			{flr=strcmp(s2,ll->GiveElement(i)->NomeFile());
			if (flr==0) n2=i;}
	char *nm;
	nm=new char[FILE_NAME_LENGTH];
	SpettroFile* temp=new SpettroFile(*ll->GiveElement(n2));
	SpettroFile* old=new SpettroFile(*ll->GiveElement(n1));   //save original
	int res=ll->GiveElement(n1)->Add(*temp);
	if (res==0)
		 MessageBox("One spectrum is inverted",
						  "Add Error",MB_OK|MB_ICONEXCLAMATION);
	else if (res==1)
			MessageBox("Impossible to interpolate the second spectrum",
						  "Add Error",MB_OK|MB_ICONEXCLAMATION);
	else
		{
			 ll->ReplicaSpettro(n1);                  //append picked
			 sprintf(nm,"Sum of %2d and %2d",n1,n2);
			 ll->GiveElement(ll->NSpettri())->CambiaNome(nm);   //change name
			 ll->PutElement(n1,*old); 								 //restore old
			 pl->Parameters();
			 pl->Clear();
		}
	delete old;
	delete temp;
  }
  delete dia3;
  return 1;
}

LRESULT TWndw::MsMatSub(WPARAM,LPARAM)
{
  int n1,n2,i,flr;
  char s1[FILE_NAME_LENGTH],s2[FILE_NAME_LENGTH];
  n1=0;
  n2=0;
  TDlg* dia3=new TDlg(this,DIALOG_9);
  dia3->SetCaption("Subtract");
  int result=dia3->Execute();
  if  (result==IDOK)
  {
	dia3->tbadsu.lbd1.GetSelString(s1,sizeof(s1));
	dia3->tbadsu.lbd2.GetSelString(s2,sizeof(s2));
	for (i=1;i<=ll->NSpettri();i++)
			{flr=strcmp(s1,ll->GiveElement(i)->NomeFile());
			if (flr==0) n1=i;}
	for (i=1;i<=ll->NSpettri();i++)
			{flr=strcmp(s2,ll->GiveElement(i)->NomeFile());
			if (flr==0) n2=i;}
	char *nm;
	nm=new char[FILE_NAME_LENGTH];
	SpettroFile* temp=new SpettroFile(*ll->GiveElement(n2));
	SpettroFile* old=new SpettroFile(*ll->GiveElement(n1));   //save original
	int res=ll->GiveElement(n1)->Sub(*temp);
	if (res==0)
		 MessageBox("One spectrum is inverted",
						  "Subtract Error",MB_OK|MB_ICONEXCLAMATION);
	else if (res==1)
			MessageBox("Impossible to interpolate the second spectrum",
						  "Subtract Error",MB_OK|MB_ICONEXCLAMATION);
	else
		{
			 ll->ReplicaSpettro(n1);                  //append picked
			 sprintf(nm,"Difference of %2d and %2d",n1,n2);
			 ll->GiveElement(ll->NSpettri())->CambiaNome(nm);   //change name
			 ll->PutElement(n1,*old); 								 //restore old
			 pl->Parameters();
			 pl->Clear();
		}
	delete old;
	delete temp;
  }
  delete dia3;
  return 1;
}

LRESULT TWndw::MsMatBS(WPARAM,LPARAM)
{
 //salto la scelta-spettro se ho un solo spettro o e' gia' selezionato
  int ns=ll->ReturnMarked();
  if ((pl->RitornaLista()->NSpettri()>1)&&(ns==0)) ns=this->SelectSpectrum();
  else if (ns==0) ns=1;  //se e' vera significa che ho un solo spettro

  if ((ns>0)&&(ns<=pl->RitornaLista()->NSpettri()))
	 {
		 TDlg* dia=new TDlg(this,DIALOG_10);
		 int result=dia->Execute();
		 if  (result==IDOK)
		 {
			int tipo;
			if (dia->tbbs.radio_shirley==TRUE) tipo=1; else tipo=0;
			char *nm,*ms;
			nm=new char[FILE_NAME_LENGTH];
			ms=new char[FILE_NAME_LENGTH];
			SpettroFile* old=new SpettroFile(*ll->GiveElement(ns));   //save original
			int nit=ll->GiveElement(ns)->BackSub(tipo);
			if ((nit>0)&&(tipo==1)&&(nit<20))
			{sprintf(ms,"Convergence after %2d iterations",nit);
			 MessageBox(ms,"Background Subtraction Info",MB_OK|MB_ICONASTERISK);}
			else if (nit==20)
			{sprintf(ms,"No convergence in 20 iterations");
			 MessageBox(ms,"Background Subtraction Info",MB_OK|MB_ICONASTERISK);}
			else if ((nit==0)&&(tipo==1))
			{sprintf(ms,"Problems in background subtraction");
			 MessageBox(ms,"Background Subtraction Info",MB_OK|MB_ICONASTERISK);}
			delete ms;
			ll->ReplicaSpettro(ns);                  //append picked
			sprintf(nm,"Background subtraction from # %2d",ns);
			ll->GiveElement(ll->NSpettri())->CambiaNome(nm);   //change name
			ll->PutElement(ns,*old);
			pl->Parameters();
			pl->Clear();
			delete old;
		 }
		 delete dia;
	 }
  return 1;
}

LRESULT TWndw::MsPlotZoom(WPARAM,LPARAM)
{
	TDialog* dia=new TDlg(this,DIALOG_3);
	int result=dia->Execute();
	if  (result==IDOK)
	{
		float a=atof(pl->tbzoom.sbxmin);
		float b=atof(pl->tbzoom.sbxmax);
		float c=atof(pl->tbzoom.sbymin);
		float d=atof(pl->tbzoom.sbymax);
		pl->ZParameters(a,b,c,d);
		pl->Clear();
		fl_original=TRUE;
	 };
	delete dia;
	return 1;
}

LRESULT TWndw::MsPlotZoomOut(WPARAM,LPARAM)
{
  pl->Parameters();
  pl->Clear();
  fl_original=FALSE;
  return 1;
}

LRESULT TWndw::MsPlotRulers(WPARAM,LPARAM)
{
  if (!rulers)
  {
	rulers=TRUE;
	rulx=-1;
	ruly=-1;
	cdc=new TClientDC(HWindow);
	TPen p1(TColor::White,1,PS_SOLID);
	cdc->SelectObject(p1);
  }
  return 1;
}


int TWndw::SelectSpectrum()
{
  int ns=0;
  TDlg* dia=new TDlg(this,DIALOG_4);
  dia->SetCaption("Select");
  int result=dia->Execute();
  if  (result==IDOK)
  {
	for (int i=1;i<=pl->RitornaLista()->NSpettri();i++)
			{int flr=strcmp(dia->file_selezionato,
								 pl->RitornaLista()->GiveElement(i)->NomeFile());
			if (flr==0) ns=i;}
  }
  delete dia;
  return ns;
}

LRESULT TWndw::MsPlotMark(WPARAM,LPARAM)
{
	if (pl->RitornaLista()->NSpettri()>1)
			 ll->MarkSpectrum(this->SelectSpectrum());
	else   ll->MarkSpectrum(1);
	pl->Clear();
	padre->Statistics();
	return 1;
}

LRESULT TWndw::MsPlotRelease(WPARAM,LPARAM)
{
	ll->MarkSpectrum(0);
	pl->Clear();
	padre->Statistics();
	return 1;
}

LRESULT TWndw::MsPlotName(WPARAM,LPARAM)
{
  //salto la scelta-spettro se ho un solo spettro o e' gia' selezionato
  int ns=ll->ReturnMarked();
  if ((pl->RitornaLista()->NSpettri()>1)&&(ns==0)) ns=this->SelectSpectrum();
  else if (ns==0) ns=1;  //se e' vera significa che ho un solo spettro
  char str[FILE_NAME_LENGTH]="";
  TInputDialog *dia=new TInputDialog(this,"Change Spectrum Name",
					  "Enter a new name:",str,sizeof(str));
  int result=dia->Execute();
  if (result==IDOK)
	  ll->GiveElement(ns)->CambiaNome(str);
  delete dia;
  pl->Clear();
  return 1;
}

LRESULT TWndw::MsConfCol(WPARAM,LPARAM)
{
  TColor temp[11];
  int i;
  for (i=0;i<=10;i++) temp[i]=pl->colore[i];  //save original colors
  TDlg* dia=new TDlg(this,DIALOG_11);
  int result=dia->Execute();
  if  (result==IDCANCEL)
	 for (i=0;i<=10;i++) pl->colore[i]=temp[i]; //restore originals
  delete dia;
  pl->Clear();
  return 1;
}

LRESULT TWndw::MsConfPref(WPARAM,LPARAM)
{
  TDlg* dia=new TDlg(this,DIALOG_13);
  int result=dia->Execute();
  if  (result==IDOK)
  {
	 if (dia->tbpref.radio_point==TRUE) ll->pref_style=ST_POINT;
		 else ll->pref_style=ST_LINE;
	 ll->pth=atoi(dia->tbpref.sb_pointth);
	 ll->lth=atoi(dia->tbpref.sb_lineth);
	 if (chdir(dia->tbpref.sb_wordir)==0) strcpy(cd,dia->tbpref.sb_wordir);
  }
  delete dia;
  return 1;
}


LRESULT TWndw::MsPlotStyl(WPARAM,LPARAM)
{
	TDlg* dia=new TDlg(this,DIALOG_12);
	int result=dia->Execute();
	int i;
	if  (result==IDOK)
	{
		for (i=1;i<=10;i++)
		  {
			 if (dia->tbline.lp[i-1][0]=='l')
				 ll->SetLineType(i,ST_LINE);
			 else ll->SetLineType(i,ST_POINT);
			 ll->SetCerchio(i,atoi(dia->tbline.spth[i-1]));
			 ll->SetPenWidth(i,atoi(dia->tbline.slth[i-1]));
			 if (i<=ll->NSpettri())
					ll->GiveElement(i)->CambiaNome(dia->tbline.fn[i-1]);
			 pl->Clear();
		 };
	 };
	delete dia;
	return 1;
}

