# if !defined MAIN_H
# define MAIN_H

#include "spettro.h"
#include "extra.h"
#include <owl\dialog.h>
#include <owl\applicat.h>
#include <owl\edit.h>
#include <owl\listbox.h>
#include <owl\validate.h>
#include <owl\radiobut.h>
#include <owl\opensave.h>
#include <owl\printer.h>
#include <owl\controlb.h>
#include <owl\messageb.h>
#include <owl\textgadg.h>
#include <owl\buttonga.h>
#include <owl\editfile.rh>
#include <owl\inputdia.h>
#include <owl\chooseco.h>
#include "spettro.rc"


class TDec;     //declaration before definition

// The client window class.
class TWndw : public TWindow
{
public:
	TWndw(TWindow *parent, const char far *title);
	void GetFather(TDec* father);
	SpettroPlot* pl;
	ListaSpettri* ll;
	BOOL fl_original,rulers;
protected:
	int SelectSpectrum();
	void SetupWindow();
	void CleanupWindow();
	BOOL CanClose();
	char far *GetClassName();
	void GetWindowClass(WNDCLASS &wndclass);
	void EvLButtonDown(UINT,TPoint&);
	void EvRButtonDown(UINT,TPoint&);
	void EvMouseMove(UINT,TPoint& point);
	LRESULT MsPointSize(WPARAM,LPARAM);
	LRESULT MsFileNew(WPARAM,LPARAM);
	LRESULT MsFileLoad(WPARAM,LPARAM);
	LRESULT MsFileSaveAs(WPARAM,LPARAM);
	LRESULT MsFileUnLoad(WPARAM,LPARAM);
	LRESULT MsFileImportVGX(WPARAM,LPARAM);
	LRESULT MsEditCopyMetaFile(WPARAM,LPARAM);
	LRESULT MsEditCopyClipboard(WPARAM,LPARAM);
	LRESULT MsFilePrint(WPARAM,LPARAM);
	LRESULT MsFilePrintSetup(WPARAM,LPARAM);
	LRESULT MsMatParam(WPARAM,LPARAM);
	LRESULT MsMatOriginal(WPARAM,LPARAM);
	LRESULT MsMatPick(WPARAM,LPARAM);
	LRESULT MsMatDerive(WPARAM,LPARAM);
	LRESULT MsMatIntegrate(WPARAM,LPARAM);
	LRESULT MsMatConv(WPARAM,LPARAM);
	LRESULT MsMatNorma(WPARAM,LPARAM);
	LRESULT MsMatInterp(WPARAM,LPARAM);
	LRESULT MsMatAdd(WPARAM,LPARAM);
	LRESULT MsMatSub(WPARAM,LPARAM);
	LRESULT MsMatBS(WPARAM,LPARAM);
	LRESULT MsPlotZoom(WPARAM,LPARAM);
	LRESULT MsPlotZoomOut(WPARAM,LPARAM);
	LRESULT MsPlotRulers(WPARAM,LPARAM);
	LRESULT MsPlotMark(WPARAM,LPARAM);
	LRESULT MsPlotRelease(WPARAM,LPARAM);
	LRESULT MsPlotName(WPARAM,LPARAM);
	LRESULT MsPlotStyl(WPARAM,LPARAM);
	LRESULT MsConfCol(WPARAM,LPARAM);
	LRESULT MsConfPref(WPARAM,LPARAM);
	LRESULT MsSize(WPARAM width,LPARAM height);
	void Paint(TDC &pDC,BOOL,TRect&);
	int color,rulx,ruly;
	float l,r;
	TOpenSaveDialog::TData  *FileDataOpen,*FileDataSave, *FileDataMeta;
	TFileOpenDialog  *ofd;
	TFileSaveDialog  *sfd, *smeta;
	char* nomefile;
	TDec* padre;
	TPrinter *printer;
	TClientDC *cdc;

	DECLARE_RESPONSE_TABLE(TWndw);
};


// The main Window class
class TDec:public TDecoratedFrame
{
public:
	TDec(TWindow *parent,const char far *title,TWndw* client,
			BOOL trackMenSel);
	void Statistics();
	char *current_directory;
protected:
	void EvLButtonDown(UINT,TPoint& point);
	void EvRButtonDown(UINT,TPoint&);
	void EvMouseMove(UINT,TPoint& point);
	void CleanupWindow();
	void CmPointSize();
	void CmFileLoad();
	void CmFileSaveAs();
	void CmFileNew();
	void CmFileUnLoad();
	void CmFileImportVGX();
	void CmFilePrint();
	void CmFilePrintSetup();
	void CmEditCopyMetaFile();
	void CmEditCopyClipboard();
	void CmMatParam();
	void CmMatOriginal();
	void CmMatPick();
	void CmMatDerive();
	void CmMatIntegrate();
	void CmMatConv();
	void CmMatNorma();
	void CmMatInterp();
	void CmMatAdd();
	void CmMatSub();
	void CmMatBS();
	void CmPlotZoom();
	void CmPlotZoomOut();
	void CmPlotRulers();
	void CmPlotMark();
	void CmPlotRelease();
	void CmPlotName();
	void CmPlotStyl();
	void CmHelpAbout();
	void CmHelpContents();
	void CmConfCol();
	void CmConfPref();
	void CmEnableFileNew(TCommandEnabler &ce);
	void CmEnableFileLoad(TCommandEnabler &ce);
	void CmEnableFileImportVGX(TCommandEnabler &ce);
	void CmEnableFileSaveAs(TCommandEnabler &ce);
	void CmEnableFilePrint(TCommandEnabler &ce);
	void CmEnableFileUnLoad(TCommandEnabler &ce);
	void CmEnableEditCopyMetaFile(TCommandEnabler &ce);
	void CmEnableEditCopyClipboard(TCommandEnabler &ce);
	void CmEnablePlotZoom(TCommandEnabler &ce);
	void CmEnablePlotZoomOut(TCommandEnabler &ce);
	void CmEnablePlotRulers(TCommandEnabler &ce);
	void CmEnablePointSize(TCommandEnabler &ce);
	void CmEnablePlotMark(TCommandEnabler &ce);
	void CmEnablePlotRelease(TCommandEnabler &ce);
	void CmEnablePlotName(TCommandEnabler &ce);
	void CmEnableMatParam(TCommandEnabler &ce);
	void CmEnableMatOriginal(TCommandEnabler &ce);
	void CmEnableMatPick(TCommandEnabler &ce);
	void CmEnableMatDerive(TCommandEnabler &ce);
	void CmEnableMatIntegrate(TCommandEnabler &ce);
	void CmEnableMatConv(TCommandEnabler &ce);
	void CmEnableMatNorma(TCommandEnabler &ce);
	void CmEnableMatInterp(TCommandEnabler &ce);
	void CmEnableMatAdd(TCommandEnabler &ce);
	void CmEnableMatSub(TCommandEnabler &ce);
	void CmEnableMatBS(TCommandEnabler &ce);
	void EvSize(UINT,TSize&);
	TWndw* cliente;
	TTextGadget *tx,*ty,*ta,*tg,*txs,*tys;
	TButtonGadget *b1,*b2,*b3,*b4,*b5,*b6;
	char *stx,*sty,*sta,*stg,*stxs,*stys;
	TControlBar *cntrlbar, *leftbar;
	TMessageBar *msgbar;


	DECLARE_RESPONSE_TABLE(TDec);
};



class TWndwPrintout:public TPrintout
{
  protected:
  TWindow *tw;
  public:
  TWndwPrintout(const char far *title, TWindow *w);
  void GetDialogInfo(int &minPage, int &maxPage,
			  int &selFromPage, int &selToPage);
  void PrintPage(int, TRect &rect, unsigned);
};

class TDlg:public TDialog
{
  private: int numero;
  void SelCol(int nb);
  public:
  TDlg(TWndw* parent,TResId resID, int ns=0);
  ~TDlg();
  void SetupWindow();
  protected:
  void EvListBoxSelChange();
  void EvPushButtonAllign();
  void EvCheckBox1();
  void EvCheckBox2();
  void EvRadioButton1();
  void EvRadioButton2();
  void EvRadioButton3();
  void EvColBut0();
  void EvColBut1();
  void EvColBut2();
  void EvColBut3();
  void EvColBut4();
  void EvColBut5();
  void EvColBut6();
  void EvColBut7();
  void EvColBut8();
  void EvColBut9();
  void EvColBut10();

  TListBox *lista_di_spettri,*lbn1,*lbn2,*las1,*las2;
  TEdit *edit,*editxmax,*editxmin,*editymax,*editymin,
		  *edgain,*edxshift,*edyshift,*editgauss,*editlor,*editnor,
		  *edleft,*edright,*edstep,
		  *edfn[10],*edlp[10],*edlth[10],*edpth[10],
		  *edlinth,*edpoth,*edwordir;
  TValidator *valid,*vxmin,*vxmax,*vymin,*vymax,*vgain,
				 *vxshift,*vyshift,*vgauss,*vlor,*vnor,*vleft,*vright,*vstep,
				 *vlp[10],*vlth[10],*vpth[10],
				 *vlinth,*vpoth;
  TRadioButton *tr1,*tr2,*rn1,*rn2,*rn3,*rb81,*rb82,*rb101,*rb102,*rb131,*rb132;
  TCheckBox *ck1,*ck2;
  TButton *b[11];
  TWndw* genitore;
  TResId tipo_dialogo;
  public:
  char file_selezionato [FILE_NAME_LENGTH];
  struct
{
	char sbgain[10];
	char sbxshift[10];
	char sbyshift[10];
	BOOL radio1;
	BOOL radio2;
} tbpar;	  			//Spectrum parameters buffer

  struct
{
  BOOL check_g;
  BOOL check_l;
  char sb_g[10];
  char sb_l[10];
} tbconv;     //Convolution buffer

struct
{
  TListBoxData lbd1;
  TListBoxData lbd2;
  BOOL radio_1;
  BOOL radio_2;
  BOOL radio_3;
  char sb_3[10];
} tbnor;		//Norma buffer

struct
{
 char sb_left[10];
 char sb_right[10];
} tbpick;

struct
{
 char sb_left[10];
 char sb_step[10];
 char sb_right[10];
 BOOL radio_lin;
 BOOL radio_splin;
} tbint;

struct
{
  TListBoxData lbd1;
  TListBoxData lbd2;
} tbadsu;

struct
{
  BOOL radio_shirley;
  BOOL radio_linear;
} tbbs;


struct
{
  char lp[10][2];
  char spth[10][3];
  char slth[10][3];
  char fn[10][50];
} tbline;

struct
{
  BOOL radio_line;
  BOOL radio_point;  
  char sb_lineth[10];
  char sb_pointth[10];
  char sb_wordir[30];
} tbpref;


  DECLARE_RESPONSE_TABLE(TDlg);
};

#endif
