#include "extra.h"

extern char *cd; //current directory

// lista di spettri per il plot
ListaSpettri::ListaSpettri(TWindow *parent)
{
	genitore=parent;
	n_elementi=0;
	marked=0;
	memset(&sbt,0,sizeof(sbt));

	char* ini_file;
	ini_file=new char[FILE_NAME_LENGTH];
	strcpy(ini_file,cd);
	strcat(ini_file,"\\prisma.ini");
	ifstream f1(ini_file);

	if (f1)
	{
	  char ini_string[30];
	  int l,p,s;
	  GetPrivateProfileString("Preferences","l/p th","1 3",ini_string,30,ini_file);
	  istrstream ins1(ini_string,strlen(ini_string));
	  ins1>>l>>p;
	  lth=l;
	  pth=p;
	  GetPrivateProfileString("Preferences","l/p style","0",ini_string,30,ini_file);
	  istrstream ins2(ini_string,strlen(ini_string));
	  ins2>>s;
	  if (s==0) pref_style=ST_POINT; else pref_style=ST_LINE;
	  GetPrivateProfileString("Preferences","workdir",cd,ini_string,30,ini_file);
	  if (chdir(ini_string)==0) strcpy(cd,ini_string);
	}
	else
	{
		lth=1;
		pth=3;
		pref_style=ST_POINT;
	}
	delete ini_file;

	for (int i=1;i<=10;i++)
	{
	 cerchio[i-1]=pth;           //default circle size
	 ltp[i-1]=pref_style;       //default plotting style
	 pw[i-1]=lth;                //default pen width
	}
}

ListaSpettri::~ListaSpettri()
{
for (int i=1;i<=n_elementi;i++)
  delete lista[i-1];
}

void ListaSpettri::Svuota()
{
for (int i=1;i<=n_elementi;i++)
  delete lista[i-1];
n_elementi=0;
marked=0;
}

int ListaSpettri::NSpettri()
{
  return n_elementi;
}

int ListaSpettri::CaricaSpettro(char* nome,int load_type)
{
lista[n_elementi]=new SpettroFile(nome);
int flag;
if (load_type==1) flag=lista[n_elementi]->ImportVGX900();
else flag=lista[n_elementi]->CaricaFile();
if (flag)
  {if (n_elementi>0)
		{cerchio[n_elementi]=cerchio[n_elementi-1];
		 ltp[n_elementi]=ltp[n_elementi-1];
		 pw[n_elementi]=pw[n_elementi-1];}
	else
		 {cerchio[0]=pth;ltp[0]=pref_style;pw[0]=lth;};
	xshift[n_elementi]=0;
	yshift[n_elementi]=0;
	gain[n_elementi]=1;
	xsign[n_elementi]=1;
	n_elementi++;}
else{delete lista[n_elementi];
	  genitore->MessageBox("Error in Input File","Input",
		 MB_OK|MB_ICONEXCLAMATION);}
return n_elementi;
}

int ListaSpettri::ReplicaSpettro(int ns)
{
  if ((ns>0)&&(ns<=n_elementi)&&(n_elementi<MAX_SPECTRA))
  {
	 lista[n_elementi]=new SpettroFile(*lista[ns-1]);
	 cerchio[n_elementi]=cerchio[ns-1];
	 ltp[n_elementi]=ltp[ns-1];
	 pw[n_elementi]=pw[ns-1];
	 xshift[n_elementi]=xshift[ns-1];
	 yshift[n_elementi]=yshift[ns-1];
	 gain[n_elementi]=gain[ns-1];
	 xsign[n_elementi]=xsign[ns-1];
	 n_elementi++;
	 return n_elementi;
  }
  else return 0;
}

void ListaSpettri::PutElement(int i,SpettroFile &sf)
{
  *lista[i-1]=sf;
}

int ListaSpettri::ScaricaSpettro(int idx)
{
if ((idx<=n_elementi)&&(idx>0))
  {if (idx==marked) marked=0;
	if (idx<marked) marked--;
	for (int i=idx;i<n_elementi;i++)
	  {
		 *lista[i-1]=*lista[i];
		 gain[i-1]=gain[i];
		 xshift[i-1]=xshift[i];
		 yshift[i-1]=yshift[i];
		 xsign[i-1]=xsign[i];
		 cerchio[i-1]=cerchio[i];
		 ltp[i-1]=ltp[i];
		 pw[i-1]=pw[i];
	  };

  delete lista[n_elementi-1];
  n_elementi--;};

return n_elementi;
}

void ListaSpettri::RicaricaSpettro (int idx)
{
  if (idx<=n_elementi)
  {
	 char* tnf=new char[FILE_NAME_LENGTH];
	 strncpy(tnf,lista[idx-1]->NomeFile(),strlen(lista[idx-1]->NomeFile())+1);
	 ifstream f1(tnf);
	 if (f1)
		{SpettroFile temp(tnf);
		 int flag=temp.CaricaFile();
		 if (flag)
			{
			 *lista[idx-1]=temp;
			 cerchio[idx-1]=pth;
			 ltp[idx-1]=pref_style;
			 pw[idx-1]=lth;
			 gain[idx-1]=1;
			 xshift[idx-1]=0;
			 yshift[idx-1]=0;
			}
		 else genitore->MessageBox("Error in Input File","Input",
		 MB_OK|MB_ICONEXCLAMATION);}
	}
}

SpettroFile* ListaSpettri::GiveElement(int i)
{
  return lista[i-1];
}

void ListaSpettri::CaricaSGS(int i,float g,float xs,float ys, int xsg)
{
  if ((i>0)&&(i<=MAX_SPECTRA))
	 {
		gain[i-1]*=g;
		xshift[i-1]+=xs;
		yshift[i-1]+=ys;
		xsign[i-1]=xsg;
	 };
 }

float ListaSpettri::ReturnGain(int i)
{
  if (i<=n_elementi) return gain[i-1];
  else return 1.0;
}

float ListaSpettri::ReturnXShift(int i)
{
  if (i<=n_elementi) return xshift[i-1];
  else return 0.0;
}

float ListaSpettri::ReturnYShift(int i)
{
  if (i<=n_elementi) return yshift[i-1];
  else return 0.0;
}

int ListaSpettri::ReturnXSign(int i)
{
  if (i<=n_elementi) return xsign[i-1];
  else return 1;
}

void ListaSpettri::MarkSpectrum(int i)
{
  if ((i>=0)&&(i<=n_elementi)) marked=i;
}

int ListaSpettri::ReturnMarked()
{
  return marked;
}

void ListaSpettri::SetCerchio (int i, int c)
{
  cerchio[i-1]=c;
}

int ListaSpettri::ReturnCerchio (int i)
{
  return cerchio[i-1];
}

void ListaSpettri::SetLineType(int i,line_type lp)
{
  ltp[i-1]=lp;
}

line_type ListaSpettri::ReturnLineType(int i)
{
  return ltp[i-1];
}

void ListaSpettri::SetPenWidth(int i, int w)
{
  pw[i-1]=w;
}

int ListaSpettri::ReturnPenWidth(int i)
{
  return pw[i-1];
}


