/* ----------------------------------------------------
 *  Filename:           wsort.cpp
 *  Summary:            PolySort test code.
 *                      Sorts words in a text file
 *  Author:             T.W. Nelson
 *  Compiler:           BCC++ 4.0
 *  Compile options:    huge model only (for DOS)
 *  Start date:         01-Nov-1995
 *  Last update:        19-Dec-1995
 *  Version:            1.00
 * ------------------------------------------------- */

#include <limits.h>
#include <string.h>
#include <new.h>
#include <stdlib.h>
#include <stdio.h>
#include "psort_t.h"
#include "timer.h"

static char outfile[] = "data.out";

#define MAXLINE     132 /* max line length */
#define MAXWORD 7   /* maximum word length */
#define DELIMCHARS  " .!@#$%&*()+=?,`\"[]{}:;<>-\r\n"

typedef struct WordSort {
    char tok[MAXWORD];  /* word string */
    char zero;   /* insures tok is asciiz */
} WORDSORT;

/* Extend ffstream to extract words from a text file.*/
class wstream : public ffstream
{
  public:
    wstream() : ffstream() {}
    wstream( const char *name ) :
       ffstream( name, "rb" ) {}
    void open( const char *name )
        {   ffstream::open( name, "rb" );
        }
    size_t read( void *, size_t, size_t);
    size_t write(const void *, size_t, size_t)
        {   return 0;     /* disabled */
        }
};

size_t wstream::read( void *buf, size_t sz, size_t n )
{
    void *p = buf;
    WordSort rec;
    static char *ptok = NULL;
    static char linebuf[MAXLINE];
    rec.zero = 0;

    for( size_t cnt = 0; cnt < n; )
    {
        if( ptok == NULL )
        {
            fgets( linebuf, MAXLINE, filep() );
            if( eof() || strlen(linebuf) == 0 )
                    break;  /* eof or error */
        }
        for( ; cnt < n; cnt++ )
        {
            ptok = strtok( ptok ? NULL : linebuf,
                                        DELIMCHARS );
            if( ptok == NULL )
                    break;  /* end of line */
            strncpy( rec.tok, ptok, MAXWORD );
            memcpy( p, (void *) &rec, sz );
            (char *) p += sz;  //sz == sizeof(WordSort)
        }
    }

    return cnt;
}

static int comp_WORDSORT( const WORDSORT **lhs, const WORDSORT **rhs )  {
    return strcmp( (*lhs)->tok, (*rhs)->tok );   //ascending ord
    //return strcmp( (*rhs)->tok, (*lhs)->tok );   //descending ord
}

enum argtag { PROGNAME, BUFSIZE, NUMFILES, INPUTFILE };

int main( int argc, char **argv )
{
    if( argc < 4 )
    {   cout << "Sort words in a text file.  Usage:\n";
        cout << "WSORT <bufsize> <#files> <inputfile>\n";
        cout << "Sorted output contained in \""
             << outfile << "\"" << endl;
        return 0;
    }

    Timer tm;
    wstream in( argv[INPUTFILE] );

    if( !in )
    {   cout << "Can't find " << argv[INPUTFILE] << endl;
        return -1;
    }

    TPolySort<WORDSORT> psrt( (fcmp_t) comp_WORDSORT,
                              (int) atoi( argv[NUMFILES] ),
                              (size_t) atoi( argv[BUFSIZE] ) );
    tm.TimerReset();
    psrt.Sort( &in, outfile );

    //**** NOTE ****
    //For some reason, the program won't load the floating point overlay
    //like it's supposed to when used with printf() or cout alone.  I
    //had to use fcvt() instead to get the program to run w/o a runtime
    //error.  Here the time (in seconds) is printed with 2 decimal places;
    //fcvt() itself doesn't print the decimal point.  I didn't care to
    //spend time cleaning this one up.......

    int dec;    //position of decpoint relative to beginning of string
    int sign;
    cout << "Sort time = "
         << fcvt(tm.ElapsedTime(), 2, &dec, &sign)
         << "/100 seconds\n";

    return 0;
}

/* ----- EOF --------------------------------------- */
