/* ----------------------------------------------------
 *  Filename:           rint.c
 *  Summary:            create file of integers, either
 *                      random or ordered
 *  Author:             T.W. Nelson
 *  Compiler:           BCC++ 4.0
 *  Compile options:
 *  Start date:         31-Oct-1995
 *  Last update:        22-Dec-1995
 *  Version:            1.00
 * ------------------------------------------------- */

#include <stdlib.h>
#include <time.h>
#include <iostream.h>
#include "ffstream.h"

typedef unsigned long ULINT;
typedef unsigned int  UINT;
char datfile[] = "data.in";
int RANDOM = 1;

int main( int argc, char **argv )
{
    if( argc < 2 )
    {   cout << "Need length argument\n";
        return 0;
    }

    ULINT rnum;
    ULINT lim = atol( argv[1] );
    ffstream ffs( datfile, "wb" );

    srand( (UINT) time(NULL) );     //initialize

    for( long j = 1; j <= lim; j++ )
    {   if( RANDOM )
        {   rnum = (ULINT) rand();
            rnum <<= 16;  //shift to high word
            rnum += (UINT) rand();    //add in random low word
            ffs.write( (const void *) &rnum, sizeof(ULINT), 1);
        }
        else    //non-random, sequential order
            ffs.write( (const void *) &j, sizeof(ULINT), 1);
    }

    return 0;
}

/* ----- EOF --------------------------------------- */
