/* ----------------------------------------------------
 *  Filename:           psort_t.h
 *  Summary:            PolySort template interface
 *  Author:             T.W. Nelson
 *  Compiler:           BCC++ 4.0
 *  Compile options:    huge model
 *  Start date:         20-Dec-1995
 *  Last update:        20-Dec-1995
 *  Version:            1.00
 * ------------------------------------------------- */

#if !defined __PSORT_T_H
#define __PSORT_T_H
#if !defined __PSORT_H
#include "psort.h"
#endif

template <class T>
class TPolySort
{
    TPolySort( const TPolySort & obj );
    TPolySort & operator= (const TPolySort & obj);
    InternalSort *Ins;
    PolySort *Ps;

  public:
    TPolySort( fcmp_t cmp,
               int nfiles = 5,
               size_t buflen = UINT_MAX,
               sort_t srt = qsort )
        {    Ins = new InternalSort( sizeof(T), cmp, srt );
             Ps = new PolySort( *Ins, nfiles, buflen );
        }
    ~TPolySort()
        {   delete Ins;
            delete Ps;
        }
    void Sort( ffstream *input, const char * output )
        {   Ps->Sort( input, output );
        }
};

#endif
/* ----- EOF --------------------------------------- */
