/* ----------------------------------------------------
 *  Filename:           fib.c
 *  Summary:            Generate ideal fibonacci matrix
 *  Author:             T.W. Nelson
 *  Compiler:           BCC++ 4.0
 *  Compile options:
 *  Start date:         25-Nov-1995
 *  Last update:        10-Dec-1995
 *  Version:            1.00
 *
 * ------------------------------------------------- */

#include <iostream.h>
#include <iomanip.h>
#include <stdlib.h>

int Fib[30];
int _Fib[30];
int Rows, Columns, Tail;

int main( int argc, char **argv )
{
    if( argc < 3 )
    {   cout << "Usage:\n\n"
             << "fib <#rows> <#columns>\n";
        return 0;
    }

    Rows = atoi( argv[1] );
    Columns  = atoi( argv[2] );

    if( Columns > 20 )
    {   cout << "Must be <= 20 columns.\n";
        return 0;
    }

    Tail = Columns - 1;
    Fib[Tail] = 1;   //seed value

    while( Rows-- )
    {   int beg = Fib[Tail];

        for( int i = 1; i <= Tail; i++ )
            _Fib[i] = Fib[i-1] + beg;

        _Fib[0] = beg;

        for( int j = 0; j <= Tail; j++ )
        {   Fib[j] = _Fib[j];   //copy
            cout.width(5);
            cout.setf( ios::left, ios::adjustfield);
            cout << Fib[j];
        }

        cout << endl;
    }

    return 0;
}

/* ----- EOF --------------------------------------- */
