/*
 *  Listing 2   mfile.h
 */

#if !defined __MFILE_H
#define __MFILE_H
#include <stdio.h>      /* tmpnam(), rename() */
#include "insort.h"
#include "ffstream.h"

class MergeFile   {
    PDATA _pbuf;    /* -> i/o buffer */
    PDATA _ppos;    /* buffer put pointer */
    PDATA _gpos;    /* buffer get pointer */
    PDATA _lpos;    /* last item put */
    char _tmpf[ L_tmpnam ];  /* tempfile name */
    const char *_fn;  /* -> file name */
    ffstream *Mf;   /* associated stream */
    const char * _fmode;     /* ffstream file mode */
    int _tmpfile;  /* !0 if temp file used */
    int _eofile;    /* end of stream data */
    size_t _items;  /* buffer item count */
    size_t _actual_runs, _null_runs;
    const int _width;     /* sizeof items, bytes */
    const int _maxitems;  /* Max #items /buffer */
    const int _holdtmps;  /* keep temp files (debug) */

  protected:
    void _resetp()  /* reset buffer pointers */
        { _gpos = _ppos = _lpos = _pbuf; }
    void _advp( PDATA &p )  /* advance buf pointer */
        { (char*) p += _width;  }
    virtual void _flushb(); /* flush buffer */
    virtual void _fillb(); /* fill buffer */
    PCDATA _getb();
    int _is_empty() const { return (_items == 0);  }

  public:
    friend class PreSort;
    enum io_mode { in, out };
    MergeFile( const int wd, const size_t blen,
               const char *mode = "w+b" );
    virtual ~MergeFile();
    size_t Actual() const { return _actual_runs; }
    size_t Null() const   { return _null_runs; }
    void Actual(size_t n) { _actual_runs = n; }
    void Null(size_t n)   { _null_runs = n; }
    PCDATA Nextg();
    PCDATA Lastp() const { return (PCDATA) _lpos; }
    PCDATA Get();
    PCDATA Put(PCDATA);
    const char *Fname() const { return _fn; }
    size_t Items() const { return _items; }
    int RenameOutput( const char * );
    void ResetIOMode(io_mode);
    int EndOfFile() const { return _eofile;  }
    void AttachStream( ffstream * );
    operator int ()     //assert valid object
        { return (_pbuf != 0) && *Mf; }
    int operator == (MergeFile & p)
        { return &p == this; }  //for container lib
};

class PreSort   {
    MergeFile *Sf;    /* Source file */
    const InternalSort *Ins;
    PPCDATA _psbuf;   /* presort buffer */
    PPCDATA _psb;     /* -> presort buffer */
  protected:
    void _putsbuf(PCDATA p) { *_psb++ = p; }
    PCDATA _getsbuf() { return *_psb++;  }
    void _setsbuf() { _psb = _psbuf; }
  public:
    PreSort( MergeFile&, const InternalSort& );
    ~PreSort() { if( _psbuf )
                    delete _psbuf;  }
    operator int ()     //assert valid object
        {   return _psbuf != 0; }
    size_t GenerateRun( MergeFile *dest, int& comp );
    int EndOfFile() const { return Sf->EndOfFile(); }
};
#endif  // EOF
