/*
 *  Listing 4     insort.h
 */

#if !defined __INSORT_H
#define __INSORT_H
#include <stdlib.h>     /* qsort()  */
#include "sortdefs.h"

class InternalSort  {
    fcmp_t _fcmp;   /* item comparison func */
    sort_t _fsort;  /* default presorter is qsort() */
    const size_t _width;  /* data size, bytes */
  public:
    InternalSort( size_t sz, fcmp_t cmp,
                             sort_t s = qsort )
           : _width(sz), _fcmp(cmp), _fsort(s)  { }
    size_t Width() const { return _width; }
    void Sort( PDATA ptab, size_t nelem ) const {
        _fsort( ptab, nelem, sizeof(PCDATA), _fcmp );
        }
    int Compare( PPCDATA left, PPCDATA right ) const {
        return _fcmp( left, right );
        }
};
#endif  // EOF
