/*
 *  Listing 10     examp.c
 *  use huge model (for DOS)
 */

#include <string.h>
#include <stdlib.h>
#include <time.h>
#include "psort.h"

int comp_long( const long **lhs, const long **rhs )
{   return (int) (**lhs - **rhs);    //ascending ord
    //return (int) (**rhs - **lhs);   //descending ord
}
int main()
{   static char *infile = "data.in";
    static char *outfile = "data.out";
    InternalSort is( sizeof(long), (fcmp_t) comp_long);
    PolySort psrt( is, 5, 40000U );
    ffstream ffs( infile, "rb" );
    if( !ffs )  {   //create file of random ints....
        ffs.open( infile, "w+b" );
        srand( (unsigned) time(NULL) );     //init
        for( long i = 150000L; i; i-- )
        {   size_t rnum = (size_t) rand();
            ffs.write( (PCDATA) &rnum,
                                 sizeof(int), 1);
        }
        ffs.rewind();
    }
    cout << "Sorting " << infile << endl;
    psrt.Sort( &ffs, outfile );
    cout << "Sorted output in " << outfile << endl;
    return 0;
} // EOF
