// **********************************************************************
//	PROGRAM: SAMPLE.C
//
//	AUTHOR: Paul D. Carlson
//
//	PURPOSE: Demonstrate tracker.dll functionality.
//
// 	NOTES:	This program was developed with the standard Windows 3.1
// 		SDK.  The program was developed and compiled using the
// 		Borland C++, Version 3.1 compiler.
//
//		This program was compiled using the medium memory model.
// **********************************************************************

#include <windows.h>
#include <stdlib.h>
#include "tracker.h"

// Key defines used later.
#define		IDM_STARTRECORDING	100
#define		IDM_STOPRECORDING	101
#define		IDM_SINGLEPLAYBACK	102
#define		IDM_MULTIPLEPLAYBACK	103
#define		IDB_OK			110
#define		IDB_CANCEL		115

long FAR PASCAL _export WndProc(HWND, UINT, UINT, LONG);

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR
	lpszCmdLine, int nCmdShow)
{
	static char szAppName[] = "sample";
	HWND	hwnd;
	MSG	msg;
	WNDCLASS wndclass;

	// Register our class.
	if (!hPrevInstance)
	{
		wndclass.style = CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc = WndProc;
		wndclass.cbClsExtra = 0;
		wndclass.cbWndExtra = DLGWINDOWEXTRA;
		wndclass.hInstance = hInstance;
		wndclass.hIcon = NULL;
		wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground = COLOR_WINDOW + 1;
		wndclass.lpszMenuName = NULL;
		wndclass.lpszClassName = szAppName;

		RegisterClass(&wndclass);
	} // end if

	// Create the dialog and display it.
	hwnd = CreateDialog(hInstance, szAppName, 0, NULL);

	if (hwnd == 0)
	{
		MessageBox(0, "Error creating dialog", "System Error", MB_OK);
		exit(0);
	}

	ShowWindow(hwnd, nCmdShow);

	// Process our application messages
	while (GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return(msg.wParam);

} // end function



long FAR PASCAL _export WndProc(HWND hwnd, UINT message, UINT wParam,
	LONG lParam)
{
	switch(message)
	{
		case WM_COMMAND:
			switch (wParam)
			{
				case IDM_STARTRECORDING:
					startRecording("c:\\testme.log");

					break;

				case IDM_STOPRECORDING:
					stopRecording();

					break;

				case IDM_SINGLEPLAYBACK:
					startPlayback("c:\\testme.log", 1);

					break;

				case IDM_MULTIPLEPLAYBACK:
					startPlayback("c:\\testme.log", 10);

					break;

				case IDB_OK:
					MessageBox(0, "OK Button Pressed!", "Message", MB_OK);

					break;
               				
				case IDB_CANCEL:
					MessageBox(0, "Cancel Button Pressed!", "Message", MB_OK);

					break;

			};

			return(0);

		case WM_DESTROY:
			PostQuitMessage(0);
			return(0);
	}

	return(DefWindowProc(hwnd, message, wParam, lParam));

}
