#include <stdio.h>
#include <string.h>
#include <process.h>

#include "nmpipe.h"

class srv_cPipeServer;

// server worker thread handling class
class srv_cThread {
private:
    HANDLE           hEventShutdown;
    nmpipe_cListener Listener;

public:
    srv_cThread(const char *, HANDLE, DWORD);
    ~srv_cThread();

    void Handler();
};

// pipe server class
class srv_cPipeServer {
private:
    HANDLE         hEventShutdown;
    HANDLE      *  phThread;
    srv_cThread ** ppThread;

    int NumThreads;

    static unsigned _stdcall ServerThread(void *);

public:
    srv_cPipeServer(int, DWORD = 60000);
    ~srv_cPipeServer();

    void MainLoop();
};

srv_cThread::srv_cThread(const char *pPipeName,
    HANDLE hEventShutdown_, DWORD ClientConnectTimeOut)
:   Listener(pPipeName, hEventShutdown, ClientConnectTimeOut)
,   hEventShutdown(hEventShutdown_)
{
}

srv_cThread::~srv_cThread()
{
}

void srv_cThread::Handler()
{
    if (Listener.InError()) {
	return;
    }

    while (TRUE) {

	unsigned long cbData;

	nmpipe_eRetcode rc = Listener.Connect(INFINITE);

	if (rc == nmpipeTimeOut) {
	    break;
	}
	else if (rc != nmpipeOK) {
	    SetEvent(hEventShutdown);
	    break;
	}

	if (Listener.Read(&cbData, sizeof(cbData)) != nmpipeOK) {

	    Listener.Disconnect();
	    continue;
	}

	char *pData = new char [cbData];
	if (Listener.Read(pData, cbData) != nmpipeOK) {
	    delete pData;

	    Listener.Disconnect();
	    continue;
	}
    
	if (strcmp(pData, "shutdown") == 0) {
	    SetEvent(hEventShutdown);
	}
    
	strrev(pData);
    
	if (Listener.Write(&cbData, sizeof(cbData)) != nmpipeOK) {
	    delete pData;

	    Listener.Disconnect();
	    continue;
	}

	if (Listener.Write(pData, cbData) != nmpipeOK) {
	    delete pData;

	    Listener.Disconnect();
	    continue;
	}
    
	delete pData;
    
	Listener.Disconnect();
    }

    return;
}

srv_cPipeServer::srv_cPipeServer(int NumThreads_, DWORD ClientConnectTimeOut)
:   NumThreads(NumThreads_)
,   phThread(new HANDLE [NumThreads_])
,   ppThread(new srv_cThread * [NumThreads_])
,   hEventShutdown(0)
{
    memset(phThread, 0, sizeof(HANDLE) * NumThreads);

    hEventShutdown = CreateEvent(NULL, TRUE, FALSE, NULL);

    if (!hEventShutdown) {
	printf("Failure: CreateEvent() -- WinError = %u\n", GetLastError());
	return;
    }

    for (int i=0; i<NumThreads; i++) {
	unsigned Tid;
    
	ppThread[i] = new srv_cThread("\\\\.\\PIPE\\MYPIPE.PIP",
			    hEventShutdown, ClientConnectTimeOut);
    
	phThread[i] = (HANDLE) _beginthreadex(NULL, 0, ServerThread,
			ppThread[i], 0, &Tid);
    
	if (!phThread[i]) {
	    printf("Failure: _beginthreadex() -- errno = %u\n", _errno);
	}
    }
}

srv_cPipeServer::~srv_cPipeServer()
{
}

unsigned _stdcall srv_cPipeServer::ServerThread(void *pThreadData_)
{
    printf("Starting thread %u\n", GetCurrentThreadId());

    srv_cThread *pThread = (srv_cThread *) pThreadData_;

    pThread -> Handler();

    delete pThread;

    printf("Ending thread %u\n", GetCurrentThreadId());

    return 0;
}

void srv_cPipeServer::MainLoop()
{
    // For for all threads to end.
    DWORD rc = WaitForMultipleObjects(NumThreads, phThread, TRUE, INFINITE);

    for (int i=0; i<NumThreads; i++) {
	if (phThread[i]) {
	    CloseHandle(phThread[i]);
	}
    }

    CloseHandle(hEventShutdown);

    if (rc == WAIT_FAILED) {
	printf("Failure: WaitForMultipleObjects() -- WinError = %u\n",
		GetLastError());
    }

    if (rc == WAIT_TIMEOUT) {
	printf("Failure: WaitForMultipleObjects() -- time-out\n");
    }
}

int main()
{
    OSVERSIONINFO OSVersionInfo;

    OSVersionInfo.dwOSVersionInfoSize = sizeof(OSVersionInfo);

    GetVersionEx (&OSVersionInfo);

    if (OSVersionInfo.dwPlatformId != VER_PLATFORM_WIN32_NT) {
	printf("Named pipe servers are only supported on Windows NT.\n");
	return -1;
    }

    srv_cPipeServer PipeServer(10);

    PipeServer.MainLoop();

    return 0;
}

