#include <stdio.h>
#include <string.h>

#include "nmpipe.h"

int main(int argc, char **argv)
{
    while (TRUE) {
	nmpipe_cConnector Connector("\\\\.\\PIPE\\MYPIPE.PIP");

	if (Connector.InError()) {
	    break;
	}
    
	const char *pWriteData = argv[1] != NULL ? argv[1] : "<no data>";
	unsigned long cbWriteData = strlen(pWriteData) + 1;
    
	if (Connector.Write(&cbWriteData, sizeof(cbWriteData)) != nmpipeOK) {
	    break;
	}

	if (Connector.Write(pWriteData, cbWriteData) != nmpipeOK) {
	    break;
	}
    
	unsigned long cbData;
    
	if (Connector.Read(&cbData, sizeof(cbData), 5000) != nmpipeOK) {
	    break;
	}
    
	char *pData = new char [cbData];
    
	if (Connector.Read(pData, cbData, 5000) != nmpipeOK) {
	    delete pData;
	    break;
	}
    
	printf("%s\n", pData);
    
	delete pData;
    }
    
    return 0;
}
