//: FileAttributes.h
#if !defined(FILEATTRIBUTES_H_)
#define FILEATTRIBUTES_H_
#include <windows.h>
#include <stdexcept>

#if defined(__BORLANDC__)
 using namespace std;
#endif

class FileAttributes {
 DWORD attributes;
public:
 // "Get" functions
 inline BOOL IsDirectory() const throw() {
  return ((attributes & FILE_ATTRIBUTE_DIRECTORY )!=0); }
 inline BOOL IsArchive()  const throw() {
  return ((attributes & FILE_ATTRIBUTE_ARCHIVE   )!=0); }
 inline BOOL IsCompressed() const throw() {
  return ((attributes & FILE_ATTRIBUTE_COMPRESSED)!=0); }
 inline BOOL IsHidden()  const throw() {
  return ((attributes & FILE_ATTRIBUTE_HIDDEN    )!=0); }
 inline BOOL IsNormal()  const throw() {
  return ((attributes & FILE_ATTRIBUTE_NORMAL    )!=0); }
 inline BOOL IsReadOnly() const throw() {
  return ((attributes & FILE_ATTRIBUTE_READONLY  )!=0); }
 inline BOOL IsSystem()  const throw() {
  return ((attributes & FILE_ATTRIBUTE_SYSTEM    )!=0); }
 inline BOOL IsTemporary() const throw() {
  return ((attributes & FILE_ATTRIBUTE_TEMPORARY )!=0); }
 // Sometimes it's more useful just to have the raw number and do
 // your own comparisons versus the various FILE_ATTRIBUTE_
 // constants.
 inline DWORD Value()        const throw() { return attributes; }
 
 // "Set" functions
 inline void IsDirectory (const BOOL SetBit) throw() {
  if(SetBit) attributes |= FILE_ATTRIBUTE_DIRECTORY  ;
  else attributes &= (~FILE_ATTRIBUTE_DIRECTORY );}
 inline void IsArchive   (const BOOL SetBit) throw() {
  if(SetBit) attributes |= FILE_ATTRIBUTE_ARCHIVE    ;
  else attributes &= (~FILE_ATTRIBUTE_ARCHIVE   );}
 inline void IsCompressed(const BOOL SetBit) throw() {
  if(SetBit) attributes |= FILE_ATTRIBUTE_COMPRESSED ;
  else attributes &= (~FILE_ATTRIBUTE_COMPRESSED);}
 inline void IsHidden    (const BOOL SetBit) throw() {
  if(SetBit) attributes |= FILE_ATTRIBUTE_HIDDEN     ;
  else attributes &= (~FILE_ATTRIBUTE_HIDDEN    );}
 inline void IsNormal    (const BOOL SetBit) throw() {
  if(SetBit) attributes |= FILE_ATTRIBUTE_NORMAL     ;
  else attributes &= (~FILE_ATTRIBUTE_NORMAL    );}
 inline void IsReadOnly  (const BOOL SetBit) throw() {
  if(SetBit) attributes |= FILE_ATTRIBUTE_READONLY   ;
  else attributes &= (~FILE_ATTRIBUTE_READONLY  );}
 inline void IsSystem    (const BOOL SetBit) throw() {
  if(SetBit) attributes |= FILE_ATTRIBUTE_SYSTEM     ;
  else attributes &= (~FILE_ATTRIBUTE_SYSTEM    );}
 inline void IsTemporary (const BOOL SetBit) throw() {
  if(SetBit) attributes |= FILE_ATTRIBUTE_TEMPORARY  ;
  else attributes &= (~FILE_ATTRIBUTE_TEMPORARY );}

 // Constructors. Can construct from a DWORD or another
 // FileAttribute object.
 inline FileAttributes(const DWORD NewAttributes=0) throw() :
        attributes(NewAttributes) {}
 inline FileAttributes(const FileAttributes& FA) throw() {
     attributes=FA.attributes; }
    //Assignment operator is defined for other FileAttribute objects
    //as well as for DWORDS
 inline FileAttributes& operator=(const FileAttributes& FA)
           throw() {
           if(&FA != this) attributes=FA.attributes; return *this; }
 inline FileAttributes& operator=(const DWORD dw) throw() {
     attributes=dw; return *this; }
};
#endif // FILEATTRIBUTES_H_
