------------- Listing 3: The file fiopen.c ------------------

// fiopen -- filebuf::open(const char *, ios::openmode)
#include <stdio.h>
#include <fstream>

filebuf *filebuf::open(const char *name, ios::openmode mode)
        {       // open a file
        static const char *mods[] = {
                "r", "w", "a", "rb", "wb", "ab", "r+", "w+", "a+",
                        "r+b", "w+b", "a+b", 0};
        static const int valid[] = {
                ios::in, ios::out|ios::trunc, ios::out|ios::app,
                ios::in|ios::binary, ios::out|ios::trunc|ios::binary,
                ios::out|ios::app|ios::binary, ios::in|ios::out,
                ios::in|ios::out|ios::trunc, ios::in|ios::out|ios::app,
                ios::in|ios::out|ios::binary,
                ios::in|ios::out|ios::trunc|ios::binary,
                ios::in|ios::out|ios::app|ios::binary, 0};
        FILE *fp;
        int n;
        ios::openmode atefl = mode & ios::ate;
        if (_File != 0)
                return (0);
        mode &= ~ios::ate;
        for (n = 0; valid[n] != 0 && valid[n] != mode; ++n)
                ;
        if (valid[n] == 0 || (fp = fopen(name, mods[n])) == 0)
                return (0);
        if (!atefl || fseek(fp, 0, SEEK_END) == 0)
                {       // success, initialize and return
                _Init(fp, 1);
                return (this);
                }
        fclose(fp);     // can't position at end
        return (0);
        }
