// set2.h

#include <iostream.h>
#include <vector.h>
#include <algo.h>
#include <iterator.h>

template<class T>
class Set
{
    friend ostream & operator<<(ostream &os, const Set<T> &s)
    {
        s.print(os);
        return os;
    }

public:
    bool contains(const T &) const;
    void insert(const T &);
    void remove(const T &);
    void print(ostream &) const;

private:
    vector<T> elems;
};

template<class T>
bool Set<T>::contains(const T & x) const
{
    return find(elems.begin(),elems.end(),x) != elems.end();
}

template<class T>
void Set<T>::insert(const T & x)
{
    if (!contains(x))
        elems.push_back(x);     // append
}

template<class T>
void Set<T>::remove(const T & x)
{
    elems.erase(find(elems.begin(),elems.end(),x));
}

template<class T>
void Set<T>::print(ostream & os) const
{
    os << '{';
    copy(elems.begin(),elems.end(),ostream_iterator<T>(os,"\n"));
    os << '}';
}

