LISTING 12 - Adds operators to the Date class
// date5.h

#include "bool.h"   // until compilers support type bool

class ostream;

class Date
{
    friend ostream & operator<<(ostream &, const Date &);

public:
    Date(int, int, int);
    int compare(const Date &) const;
    bool operator==(const Date &) const;
    bool operator!=(const Date &) const;
    bool operator<=(const Date &) const;
    bool operator>=(const Date &) const;
    bool operator<(const Date &) const;
    bool operator>(const Date &) const;

private:
    int month;
    int day;
    int year;

    static const char * month_text[13];
};

inline bool Date::operator==(const Date &d2) const
{
    return compare(d2) == 0;
}

inline bool Date::operator!=(const Date &d2) const
{
    return compare(d2) != 0;
}

inline bool Date::operator<=(const Date &d2) const
{
    return compare(d2) <= 0;
}

inline bool Date::operator>=(const Date &d2) const
{
    return compare(d2) >= 0;
}

inline bool Date::operator<(const Date &d2) const
{
    return compare(d2) < 0;
}

inline bool Date::operator>(const Date &d2) const
{
    return compare(d2) > 0;
}
