/*
 * Listing 6 - xwd.c (loader)
 */

#include <stdio.h>
#include <math.h>
#include <X11/XWDFile.h>
#include "ips_image.h"

void		read_ximage();

int
main(argc, argv)
int argc;
char **argv;
{
	ips_header  header;
	ips_image   image;

	
	if (argc < 3) {
		printf("Usage: %s infile outfile\n", argv[0]);
		exit(1);
	}
	
	read_ximage(&header, &image, argv[1]);

	img_to_ips(&header, &image, argv[2]);

	exit(0);
}


void 
read_ximage(header, image, filename)
ips_header	*header;
ips_image	*image;
char		*filename;
{
	int				i, pad, rightpad;
	char			buf[1024];
	FILE			*fp;
	unsigned char	*p;
	XWDColor 		xcmap[256];
	XWDFileHeader 	xheader;


	if((fp = fopen(filename, "r")) == NULL) {
		perror("read_ximage");
		exit(1);
	}

	fread(&xheader, 1, sizeof(XWDFileHeader), fp);
	fread(buf, 1, (xheader.header_size - sizeof(XWDFileHeader)), fp);
	fread(xcmap, 1, sizeof(XWDColor) * xheader.ncolors, fp);

	p = image->data = (unsigned char *)
			malloc(xheader.pixmap_width * xheader.pixmap_height);

	rightpad = xheader.bytes_per_line - xheader.pixmap_width;

	for (i=0; i<xheader.pixmap_height; i++) {
		fread((p + (i * xheader.pixmap_width)), 1, 
			xheader.pixmap_width, fp);
		
		for (pad=0; pad < rightpad; pad++) 
			fgetc(fp); 
	}

	header->bpp			= 8;
	header->cmap_count	= xheader.ncolors;
	header->width		= xheader.pixmap_width;
	header->height		= xheader.pixmap_height;

	for(i=0; i < header->cmap_count; i++) {
		image->cmap[i].pixel = i;
		image->cmap[i].red	 = xcmap[i].red >> 8;
		image->cmap[i].green = xcmap[i].green >> 8;
		image->cmap[i].blue	 = xcmap[i].blue >> 8;
	}

	fclose(fp);
}
