#define GLOBALS TRUE
#include "winjes.h"
#undef GLOBALS

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    MSG msg;

    if (!hPrevInstance)
      if (!InitApplication(hInstance))
        return (FALSE);             

    if (!InitInstance(hInstance, nCmdShow))
    return (FALSE);

    while (GetMessage(&msg, NULL, NULL, NULL))
    {
      TranslateMessage(&msg);
      DispatchMessage(&msg); 
    }
    
    return (msg.wParam);
}


BOOL InitApplication(hInstance)
    HANDLE hInstance;
{
    WNDCLASS  wc;

    wc.style = CS_DBLCLKS;
    wc.lpfnWndProc = MainWndProc; 
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(hInstance, "TellMe");
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH); 
    wc.lpszMenuName =  NULL;
    wc.lpszClassName = "jesWClass";

    return (RegisterClass(&wc));

}

BOOL InitInstance(HANDLE hInstance, int nCmdShow)
{
    HWND            hWnd;

    hInst = hInstance;

    hWnd = CreateWindow("jesWClass",
                        "WinJES",
                        WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX,
                        CW_USEDEFAULT,      
                        CW_USEDEFAULT,      
                        70,
                        50,
                        NULL,
                        NULL,
                        hInstance,
                        NULL);

    if (!hWnd)
      return (FALSE);

    ShowWindow(hWnd, nCmdShow);
    UpdateWindow(hWnd);
    return (TRUE);     

}

 
