LISTING 4 - Shows that only one user-defined conversion is
allowed

// convert4.cpp
#include <iostream.h>

struct B;

struct A
{
    double x;

    A(const B& b);
};

void f(const A& a)
{
    cout << "f: " << a.x << endl;
}

struct B
{
    double y;

    B(double d) : y(d)
    {
        cout << "B::B(double)" << endl;
    }
};

A::A(const B& b) : x(b.y)
{
    cout << "A::A(const B&)" << endl;
}

main()
{
    A a(1);
    f(a);

    B b(2);
    f(b);

    // The following won't compile:
//  f(3);

    // But these will:
    f(B(3));
    f(A(4));
    return 0;
}

// Output:
B::B(double)
A::A(const B&)
f: 1
B::B(double)
A::A(const B&)
f: 2
B::B(double)
A::A(const B&)
f: 3
B::B(double)
A::A(const B&)
f: 4

