/* A lexical scanner generated by flex */

/* scanner skeleton version:
 * $Header: /usr/fsys/odin/a/vern/flex/RCS/flex.skel,v 2.16 90/08/03 14:09:36 vern Exp $
 */

#define FLEX_SCANNER

#include <stdio.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#include <osfcn.h>

/* use prototypes in function declarations */
#define YY_USE_PROTOS

/* the "const" storage-class-modifier is valid */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#ifdef __STDC__

#ifdef __GNUC__
#include <stddef.h>
void *malloc( size_t );
void free( void* );
#else
#include <stdlib.h>
#endif	/* __GNUC__ */

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */


#ifdef __TURBOC__
#define YY_USE_CONST
#endif


#ifndef YY_USE_CONST
#define const
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
/* we can't get here if it's an ANSI C compiler, or a C++ compiler,
 * so it's got to be a K&R compiler, and therefore there's no standard
 * place from which to include these definitions
 */
char *malloc();
int free();
int read();
#endif


/* amount of stuff to slurp up with each read */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* returned upon end-of-file */
#define YY_END_TOK 0

/* copy whatever the last rule matched to the standard output */

/* cast to (char *) is because for 8-bit chars, yytext is (unsigned char *) */
/* this used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite()
 */
#define ECHO (void) fwrite( (char *) yytext, yyleng, 1, yyout )

/* gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result". uses "myflexread" under MS-DOS instead of "read" 
 * so that \r is stripped out. - David Chapman, 23 Feb 1991
 */
#ifdef MS_DOS
int myflexread(FILE *infile,char *buf,int max_size)  /* assuming ANSI */
{
    /* use fgetc() to filter out '\r' under MS-DOS, rather than read, since */
    /* scan.l doesn't include '\r' as a character. */

    char *buf_start = buf;
    int c;

    while (max_size-- && ((c = fgetc(infile)) != EOF))
        *buf++ = (char) c;
    return buf - buf_start;             /* never returns < 0; oh well - */
                                        /* can't match read() totally */
}  /* end of myflexread() */

#define YY_INPUT(buf,result,max_size) \
        if ( (result = myflexread( yyin, (char *) buf, max_size )) < 0) \
            YY_FATAL_ERROR( "read() in flex scanner failed" );

#else  /* ! MS_DOS */

/* original code here */
#define YY_INPUT(buf,result,max_size) \
        if ( (result = read( fileno(yyin), (char *) buf, max_size )) < 0 ) \
            YY_FATAL_ERROR( "read() in flex scanner failed" );

#endif  /* MS_DOS */

#define YY_NULL 0

/* no semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#define yyterminate() return ( YY_NULL )

/* report a fatal error */

/* The funky do-while is used to turn this macro definition into
 * a single C statement (which needs a semi-colon terminator).
 * This avoids problems with code like:
 *
 * 	if ( something_happens )
 *		YY_FATAL_ERROR( "oops, the something happened" );
 *	else
 *		everything_okay();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the YY_FATAL_ERROR() call.
 */

#define YY_FATAL_ERROR(msg) \
	do \
		{ \
		(void) fputs( msg, stderr ); \
		(void) putc( '\n', stderr ); \
		exit( 1 ); \
		} \
	while ( 0 )

/* default yywrap function - always treat EOF as an EOF */
#define yywrap() 1

/* enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN
 */
#define BEGIN yy_start = 1 + 2 *

/* action number for EOF rule of a given start state */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* special action meaning "start processing a new file" */
#define YY_NEW_FILE \
	do \
		{ \
		yy_init_buffer( yy_current_buffer, yyin ); \
		yy_load_buffer_state(); \
		} \
	while ( 0 )

/* default declaration of generated scanner - a define so the user can
 * easily add parameters
 */
#define YY_DECL int yylex YY_PROTO(( void )) 

/* code executed at the end of each rule */
#define YY_BREAK break;

#define YY_END_OF_BUFFER_CHAR 0

#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE (YY_READ_BUF_SIZE * 2) /* size of default input buffer */
#endif

typedef struct yy_buffer_state *YY_BUFFER_STATE;

#define YY_CHAR char
# line 1 "clexer.l"
#define INITIAL 0
# line 2 "clexer.l"

#if 0
clexer.l - flex scanner for error message handler

A quick-and-dirty scanner based on one from Tony Sanders
(cs.utexas.edu!ibmaus!auschs!sanders.austin.ibm.com!sanders)

note that I took out keyword support; they are returned as
identifiers. this reduces the number of constants I have to
define!

#endif  /* 0 */

#include <stdio.h>
#include "clexer.h"
#define STRDUP(X) ((char *)strcpy(malloc(strlen(X)+1),X))
int yychar;
#define count(x) counter(x)
#ifndef YYDEBUG
int     yydebug = 0;
#else
int     yydebug = 1;
#endif

int column;
int linenum;
char lexstringtok[MAXSTRINGLEN];        /* for string, character constants */
int  lexstringtoklen;
#ifdef __STDC__
void quotechar(char c);
void addtostring(const char *txt,int txtlen);  /* adds to lexstringtok */
#else
void quotechar();
void addtostring();
#endif  /* __STDC__ */
/* start states: used for character and string constants */
#define charconst 1
#define quotecharconst 2
#define stringtok 3
#define quotestringtok 4
# line 52 "clexer.l"

/* done after the current pattern has been matched and before the
 * corresponding action - sets up yytext
 */
#define YY_DO_BEFORE_ACTION \
	yytext = yy_bp; \
	yyleng = yy_cp - yy_bp; \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* return all but the first 'n' matched characters back to the input stream */
#define yyless(n) \
	do \
		{ \
		/* undo effects of setting up yytext */ \
		*yy_cp = yy_hold_char; \
		yy_c_buf_p = yy_cp = yy_bp + n; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yytext )


struct yy_buffer_state
    {
    FILE *yy_input_file;

    YY_CHAR *yy_ch_buf;		/* input buffer */
    YY_CHAR *yy_buf_pos;	/* current position in input buffer */

    /* size of input buffer in bytes, not including room for EOB characters*/
    int yy_buf_size;	

    /* number of characters read into yy_ch_buf, not including EOB characters */
    int yy_n_chars;

    int yy_eof_status;		/* whether we've seen an EOF on this buffer */
#define EOF_NOT_SEEN 0
    /* "pending" happens when the EOF has been seen but there's still
     * some text process
     */
#define EOF_PENDING 1
#define EOF_DONE 2
    };

static YY_BUFFER_STATE yy_current_buffer;

/* we provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state"
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed */
static YY_CHAR yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */



#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

#ifndef YY_USER_INIT
#define YY_USER_INIT
#endif

extern YY_CHAR *yytext;
extern int yyleng;
extern FILE *yyin, *yyout;

YY_CHAR *yytext;
int yyleng;

FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;

#define YY_END_OF_BUFFER 70
typedef int yy_state_type;
static const short int yy_accept[97] =
    {   0,
        0,    0,    0,    0,    0,    0,   64,   64,    0,    0,
       70,   68,    2,    2,   44,   61,    1,   39,   41,   51,
       27,   29,   35,   37,   28,   38,   45,   36,   57,   43,
       30,   47,   50,   48,   42,   67,   33,   34,   40,   31,
       68,   32,   46,   54,   56,   52,   53,   55,   64,   65,
       62,   63,   66,    2,    8,    1,   12,   25,   17,   10,
       22,    0,   59,   13,   23,   14,   24,    0,   59,    3,
        4,   11,   59,   57,    0,   58,   20,    7,    9,    6,
       21,   67,   19,   18,   26,   64,   59,   60,    5,    4,
       59,    0,   59,   15,   16,    0

    } ;

static const YY_CHAR yy_ec[128] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        2,    2,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    5,    6,    1,    7,    8,    9,   10,
       11,   12,   13,   14,   15,   16,   17,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   19,   20,   21,
       22,   23,   24,    1,   25,   25,   25,   25,   26,   25,
       25,   25,   25,   25,   25,   27,   25,   25,   25,   25,
       25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
       28,   29,   30,   31,   32,    1,   25,   25,   25,   25,

       26,   25,   25,   25,   25,   25,   25,   27,   25,   25,
       25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
       25,   25,   33,   34,   35,   36,    1
    } ;

static const YY_CHAR yy_meta[37] =
    {   0,
        1,    1,    2,    1,    3,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    3,    1,
        1,    1,    1,    1,    1,    1
    } ;

static const short int yy_base[104] =
    {   0,
        0,    0,   34,   35,  143,  142,   36,   37,    0,    0,
      144,  147,   43,   45,  121,  147,    0,  120,   45,  147,
      147,  147,  118,   36,  147,   53,   39,   39,   54,  147,
      147,   38,  115,   51,  147,   59,  147,  147,  100,  147,
       28,  147,  147,  147,  147,  147,  147,  147,    0,  147,
      147,  147,  147,   76,  147,    0,  147,  147,  147,  147,
      147,  101,   71,  147,  147,  147,  147,   97,   74,  147,
        0,  147,   76,   88,   75,  147,   89,  147,  147,  147,
       73,   91,  147,  147,  147,    0,   94,  147,  147,    0,
       81,   65,   78,  147,  147,  147,  123,  126,  129,  132,

      135,   81,  138
    } ;

static const short int yy_def[104] =
    {   0,
       96,    1,   97,   97,   98,   98,   99,   99,  100,  100,
       96,   96,   96,   96,   96,   96,  101,   96,   96,   96,
       96,   96,   96,   96,   96,   96,   96,   96,   96,   96,
       96,   96,   96,   96,   96,   96,   96,   96,   96,   96,
       96,   96,   96,   96,   96,   96,   96,   96,  102,   96,
       96,   96,   96,   96,   96,  101,   96,   96,   96,   96,
       96,   96,   96,   96,   96,   96,   96,   96,   96,   96,
      103,   96,   96,   96,   96,   96,   96,   96,   96,   96,
       96,   96,   96,   96,   96,  102,   96,   96,   96,  103,
       96,   96,   96,   96,   96,    0,   96,   96,   96,   96,

       96,   96,   96
    } ;

static const short int yy_nxt[184] =
    {   0,
       12,   13,   14,   15,   16,   17,   18,   19,   20,   21,
       22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
       32,   33,   34,   35,   36,   36,   36,   37,   12,   38,
       39,   36,   40,   41,   42,   43,   45,   45,   50,   50,
       51,   51,   46,   46,   54,   54,   54,   54,   61,   84,
       70,   62,   58,   63,   68,   71,   69,   64,   77,   78,
       72,   85,   47,   47,   52,   52,   59,   65,   62,   73,
       63,   74,   80,   81,   66,   67,   82,   54,   54,   75,
       76,   86,   93,   82,   82,   82,   73,   92,   87,   92,
       82,   69,   93,   91,   95,   93,   75,   88,   91,   75,

       88,   75,   88,   73,   88,   74,   75,   88,   82,   73,
       94,   87,   89,   75,   76,   82,   82,   82,   69,   75,
       88,   83,   82,   44,   44,   44,   48,   48,   48,   49,
       49,   49,   53,   53,   53,   56,   79,   56,   90,   60,
       90,   57,   55,   96,   45,   45,   11,   96,   96,   96,
       96,   96,   96,   96,   96,   96,   96,   96,   96,   96,
       96,   96,   96,   96,   96,   96,   96,   96,   96,   96,
       96,   96,   96,   96,   96,   96,   96,   96,   96,   96,
       96,   96,   96
    } ;

static const short int yy_chk[184] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    3,    4,    7,    8,
        7,    8,    3,    4,   13,   13,   14,   14,   24,   41,
       28,   24,   19,   24,   27,   28,   27,   24,   32,   32,
       28,   41,    3,    4,    7,    8,   19,   26,   26,   29,
       26,   29,   34,   34,   26,   26,   36,   54,   54,   29,
       29,  102,   92,   36,   36,   36,   63,   75,   63,   75,
       36,   69,   75,   73,   81,   93,   63,   63,   91,   69,

       69,   73,   73,   74,   93,   74,   91,   91,   82,   87,
       77,   87,   68,   74,   74,   82,   82,   82,   62,   87,
       87,   39,   82,   97,   97,   97,   98,   98,   98,   99,
       99,   99,  100,  100,  100,  101,   33,  101,  103,   23,
      103,   18,   15,   11,    6,    5,   96,   96,   96,   96,
       96,   96,   96,   96,   96,   96,   96,   96,   96,   96,
       96,   96,   96,   96,   96,   96,   96,   96,   96,   96,
       96,   96,   96,   96,   96,   96,   96,   96,   96,   96,
       96,   96,   96
    } ;

static yy_state_type yy_last_accepting_state;
static YY_CHAR *yy_last_accepting_cpos;

/* the intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0

/* these variables are all declared out here so that section 3 code can
 * manipulate them
 */
/* points to current character in buffer */
static YY_CHAR *yy_c_buf_p = (YY_CHAR *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

static yy_state_type yy_get_previous_state YY_PROTO(( void ));
static yy_state_type yy_try_NUL_trans YY_PROTO(( yy_state_type current_state ));
static int yy_get_next_buffer YY_PROTO(( void ));
static void yyunput YY_PROTO(( YY_CHAR c, YY_CHAR *buf_ptr ));
void yyrestart YY_PROTO(( FILE *input_file ));
void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));

#define yy_new_buffer yy_create_buffer

#ifdef __cplusplus
static int yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif

YY_DECL
    {
    register yy_state_type yy_current_state;
    register YY_CHAR *yy_cp, *yy_bp;
    register int yy_act;



    if ( yy_init )
	{
	YY_USER_INIT;

	if ( ! yy_start )
	    yy_start = 1;	/* first start state */

	if ( ! yyin )
	    yyin = stdin;

	if ( ! yyout )
	    yyout = stdout;

	if ( yy_current_buffer )
	    yy_init_buffer( yy_current_buffer, yyin );
	else
	    yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_load_buffer_state();

	yy_init = 0;
	}

    while ( 1 )		/* loops until end-of-file is reached */
	{
	yy_cp = yy_c_buf_p;

	/* support of yytext */
	*yy_cp = yy_hold_char;

	/* yy_bp points to the position in yy_ch_buf of the start of the
	 * current run.
	 */
	yy_bp = yy_cp;

	yy_current_state = yy_start;
yy_match:
	do
	    {
	    register YY_CHAR yy_c = yy_ec[*yy_cp];
	    if ( yy_accept[yy_current_state] )
		{
		yy_last_accepting_state = yy_current_state;
		yy_last_accepting_cpos = yy_cp;
		}
	    while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = yy_def[yy_current_state];
		if ( yy_current_state >= 97 )
		    yy_c = yy_meta[yy_c];
		}
	    yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	    ++yy_cp;
	    }
	while ( yy_base[yy_current_state] != 147 );

yy_find_action:
	yy_act = yy_accept[yy_current_state];

	YY_DO_BEFORE_ACTION;
	YY_USER_ACTION;

do_action:	/* this label is used only to access EOF actions */


	switch ( yy_act )
	    {
	    case 0: /* must backtrack */
	    /* undo the effects of YY_DO_BEFORE_ACTION */
	    *yy_cp = yy_hold_char;
	    yy_cp = yy_last_accepting_cpos;
	    yy_current_state = yy_last_accepting_state;
	    goto yy_find_action;

case 1:
# line 53 "clexer.l"
{ count(0); /* skip cpp lines */ }
	YY_BREAK
case 2:
# line 54 "clexer.l"
{ count(0); /* skip white space */ }
	YY_BREAK
case 3:
# line 55 "clexer.l"
{ count(1); skipcomments(); }
	YY_BREAK
case 4:
# line 56 "clexer.l"
{ count(1); /* skip C++ style comments */ }
	YY_BREAK
case 5:
# line 57 "clexer.l"
{ count(1); return DOTDOTDOT; }
	YY_BREAK
case 6:
# line 58 "clexer.l"
{ count(1); return GE; }
	YY_BREAK
case 7:
# line 59 "clexer.l"
{ count(1); return LE; }
	YY_BREAK
case 8:
# line 60 "clexer.l"
{ count(1); return NOTEQU; }
	YY_BREAK
case 9:
# line 61 "clexer.l"
{ count(1); return EQU; }
	YY_BREAK
case 10:
# line 63 "clexer.l"
{ count(1); return MULTEQU; }
	YY_BREAK
case 11:
# line 64 "clexer.l"
{ count(1); return DIVEQU; }
	YY_BREAK
case 12:
# line 65 "clexer.l"
{ count(1); return MODEQU; }
	YY_BREAK
case 13:
# line 66 "clexer.l"
{ count(1); return INCEQU; }
	YY_BREAK
case 14:
# line 67 "clexer.l"
{ count(1); return DECEQU; }
	YY_BREAK
case 15:
# line 68 "clexer.l"
{ count(1); return SHIFTLEFTEQU; }
	YY_BREAK
case 16:
# line 69 "clexer.l"
{ count(1); return SHIFTRIGHTEQU; }
	YY_BREAK
case 17:
# line 70 "clexer.l"
{ count(1); return ANDEQU; }
	YY_BREAK
case 18:
# line 71 "clexer.l"
{ count(1); return OREQU; }
	YY_BREAK
case 19:
# line 72 "clexer.l"
{ count(1); return XOREQU; }
	YY_BREAK
case 20:
# line 74 "clexer.l"
{ count(1); return SHIFTLEFT; }
	YY_BREAK
case 21:
# line 75 "clexer.l"
{ count(1); return SHIFTRIGHT; }
	YY_BREAK
case 22:
# line 76 "clexer.l"
{ count(1); return INC; }
	YY_BREAK
case 23:
# line 77 "clexer.l"
{ count(1); return DEC; }
	YY_BREAK
case 24:
# line 78 "clexer.l"
{ count(1); return POINTS; }
	YY_BREAK
case 25:
# line 79 "clexer.l"
{ count(1); return LOGICALAND; }
	YY_BREAK
case 26:
# line 80 "clexer.l"
{ count(1); return LOGICALOR; }
	YY_BREAK
case 27:
# line 82 "clexer.l"
{ count(1); return '('; }
	YY_BREAK
case 28:
# line 83 "clexer.l"
{ count(1); return ','; }
	YY_BREAK
case 29:
# line 84 "clexer.l"
{ count(1); return ')'; }
	YY_BREAK
case 30:
# line 85 "clexer.l"
{ count(1); return ';'; }
	YY_BREAK
case 31:
# line 86 "clexer.l"
{ count(1); return '{'; }
	YY_BREAK
case 32:
# line 87 "clexer.l"
{ count(1); return '}'; }
	YY_BREAK
case 33:
# line 88 "clexer.l"
{ count(1); return '['; }
	YY_BREAK
case 34:
# line 89 "clexer.l"
{ count(1); return ']'; }
	YY_BREAK
case 35:
# line 90 "clexer.l"
{ count(1); return '*'; }
	YY_BREAK
case 36:
# line 91 "clexer.l"
{ count(1); return '/'; }
	YY_BREAK
case 37:
# line 92 "clexer.l"
{ count(1); return '+'; }
	YY_BREAK
case 38:
# line 93 "clexer.l"
{ count(1); return '-'; }
	YY_BREAK
case 39:
# line 94 "clexer.l"
{ count(1); return '%'; }
	YY_BREAK
case 40:
# line 95 "clexer.l"
{ count(1); return '^'; }
	YY_BREAK
case 41:
# line 96 "clexer.l"
{ count(1); return '&'; }
	YY_BREAK
case 42:
# line 97 "clexer.l"
{ count(1); return '?'; }
	YY_BREAK
case 43:
# line 98 "clexer.l"
{ count(1); return ':'; }
	YY_BREAK
case 44:
# line 99 "clexer.l"
{ count(1); return '!'; }
	YY_BREAK
case 45:
# line 100 "clexer.l"
{ count(1); return '.'; }
	YY_BREAK
case 46:
# line 101 "clexer.l"
{ count(1); return '~'; }
	YY_BREAK
case 47:
# line 102 "clexer.l"
{ count(1); return '<'; }
	YY_BREAK
case 48:
# line 103 "clexer.l"
{ count(1); return '>'; }
	YY_BREAK
case 49:
# line 104 "clexer.l"
{ count(1); return '.'; }
	YY_BREAK
case 50:
# line 105 "clexer.l"
{ count(1); return '='; }
	YY_BREAK
case 51:
# line 107 "clexer.l"
{
        BEGIN(charconst);
        addtostring("",0);
}
	YY_BREAK
case 52:
# line 111 "clexer.l"
{
        BEGIN(INITIAL);
        count(1);
        return CHAR_CONST;
}
	YY_BREAK
case 53:
# line 116 "clexer.l"
{
        BEGIN(quotecharconst);          /* backslash quotes next char */
}
	YY_BREAK
case 54:
# line 119 "clexer.l"
{

        /* we can't use ".*" in this rule because it would eat the closing */
        /* quote. */

        addtostring(yytext,yyleng);
}
	YY_BREAK
case 55:
# line 126 "clexer.l"
{
        quotechar(yytext[0]);           /* quoted character */
        BEGIN(charconst);
}
	YY_BREAK
case 56:
# line 130 "clexer.l"
{
        BEGIN(INITIAL);
        fprintf(stderr,"newline in character constant.\n");
        yyterminate();                  /* on to next file */
}
	YY_BREAK
case 57:
# line 136 "clexer.l"
{
        count(1);
        return INTEGER_CONST;
}
	YY_BREAK
case 58:
# line 140 "clexer.l"
{
        count(1);
        return LONG_INTEGER_CONST;
}
	YY_BREAK
case 59:
# line 144 "clexer.l"
{
        count(1);
        return FLOAT_CONST;
}
	YY_BREAK
case 60:
# line 148 "clexer.l"
{
        count(1);
        return DOUBLE_CONST;
}
	YY_BREAK
case 61:
# line 153 "clexer.l"
{
        BEGIN(stringtok);
        addtostring("",0);
}
	YY_BREAK
case 62:
# line 157 "clexer.l"
{
        BEGIN(INITIAL);
        count(1);
        /* return STRING without quotes */
        return STRING;
}
	YY_BREAK
case 63:
# line 163 "clexer.l"
{
        BEGIN(quotestringtok);          /* backslash quotes next char */
}
	YY_BREAK
case 64:
# line 166 "clexer.l"
{

        /* we can't use ".*" in this rule because it would eat the closing */
        /* quote. */

        addtostring(yytext,yyleng);
}
	YY_BREAK
case 65:
# line 173 "clexer.l"
{
        fprintf(stderr,"newline in string token.\n");
        yyterminate();
}
	YY_BREAK
case 66:
# line 177 "clexer.l"
{
        quotechar(yytext[0]);           /* quoted character */
        BEGIN(stringtok);
}
	YY_BREAK
case 67:
# line 182 "clexer.l"
{                               /* identifier - includes keywords */
        count(1);
        return IDENTIFIER;
}
	YY_BREAK
case 68:
# line 186 "clexer.l"
{ count(1); return ERROR; }
	YY_BREAK
case 69:
# line 187 "clexer.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(charconst):
case YY_STATE_EOF(quotecharconst):
case YY_STATE_EOF(stringtok):
case YY_STATE_EOF(quotestringtok):
    yyterminate();

	    case YY_END_OF_BUFFER:
		{
		/* amount of text matched not including the EOB char */
		int yy_amount_of_matched_text = yy_cp - yytext - 1;

		/* undo the effects of YY_DO_BEFORE_ACTION */
		*yy_cp = yy_hold_char;

		/* note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the end-
		 * of-buffer state).  Contrast this with the test in yyinput().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
		    /* this was really a NUL */
		    {
		    yy_state_type yy_next_state;

		    yy_c_buf_p = yytext + yy_amount_of_matched_text;

		    yy_current_state = yy_get_previous_state();

		    /* okay, we're now positioned to make the
		     * NUL transition.  We couldn't have
		     * yy_get_previous_state() go ahead and do it
		     * for us because it doesn't know how to deal
		     * with the possibility of jamming (and we
		     * don't want to build jamming into it because
		     * then it will run more slowly)
		     */

		    yy_next_state = yy_try_NUL_trans( yy_current_state );

		    yy_bp = yytext + YY_MORE_ADJ;

		    if ( yy_next_state )
			{
			/* consume the NUL */
			yy_cp = ++yy_c_buf_p;
			yy_current_state = yy_next_state;
			goto yy_match;
			}

		    else
			{
			goto yy_find_action;
			}
		    }

		else switch ( yy_get_next_buffer() )
		    {
		    case EOB_ACT_END_OF_FILE:
			{
			yy_did_buffer_switch_on_eof = 0;

			if ( yywrap() )
			    {
			    /* note: because we've taken care in
			     * yy_get_next_buffer() to have set up yytext,
			     * we can now set up yy_c_buf_p so that if some
			     * total hoser (like flex itself) wants
			     * to call the scanner after we return the
			     * YY_NULL, it'll still work - another YY_NULL
			     * will get returned.
			     */
			    yy_c_buf_p = yytext + YY_MORE_ADJ;

			    yy_act = YY_STATE_EOF((yy_start - 1) / 2);
			    goto do_action;
			    }

			else
			    {
			    if ( ! yy_did_buffer_switch_on_eof )
				YY_NEW_FILE;
			    }
			}
			break;

		    case EOB_ACT_CONTINUE_SCAN:
			yy_c_buf_p = yytext + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			yy_cp = yy_c_buf_p;
			yy_bp = yytext + YY_MORE_ADJ;
			goto yy_match;

		    case EOB_ACT_LAST_MATCH:
			yy_c_buf_p =
			    &yy_current_buffer->yy_ch_buf[yy_n_chars];

			yy_current_state = yy_get_previous_state();

			yy_cp = yy_c_buf_p;
			yy_bp = yytext + YY_MORE_ADJ;
			goto yy_find_action;
		    }
		break;
		}

	    default:
#ifdef FLEX_DEBUG
		printf( "action # %d\n", yy_act );
#endif
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	    }
	}
    }


/* yy_get_next_buffer - try to read in a new buffer
 *
 * synopsis
 *     int yy_get_next_buffer();
 *     
 * returns a code representing an action
 *     EOB_ACT_LAST_MATCH - 
 *     EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *     EOB_ACT_END_OF_FILE - end of file
 */

static int yy_get_next_buffer()

    {
    register YY_CHAR *dest = yy_current_buffer->yy_ch_buf;
    register YY_CHAR *source = yytext - 1; /* copy prev. char, too */
    register int number_to_move, i;
    int ret_val;

    if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
	YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

    /* try to read more data */

    /* first move last chars to start of buffer */
    number_to_move = yy_c_buf_p - yytext;

    for ( i = 0; i < number_to_move; ++i )
	*(dest++) = *(source++);

    if ( yy_current_buffer->yy_eof_status != EOF_NOT_SEEN )
	/* don't do the read, it's not guaranteed to return an EOF,
	 * just force an EOF
	 */
	yy_n_chars = 0;

    else
	{
	int num_to_read = yy_current_buffer->yy_buf_size - number_to_move - 1;

	if ( num_to_read > YY_READ_BUF_SIZE )
	    num_to_read = YY_READ_BUF_SIZE;

	else if ( num_to_read <= 0 )
	    YY_FATAL_ERROR( "fatal error - scanner input buffer overflow" );

	/* read in more data */
	YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
		  yy_n_chars, num_to_read );
	}

    if ( yy_n_chars == 0 )
	{
	if ( number_to_move == 1 )
	    {
	    ret_val = EOB_ACT_END_OF_FILE;
	    yy_current_buffer->yy_eof_status = EOF_DONE;
	    }

	else
	    {
	    ret_val = EOB_ACT_LAST_MATCH;
	    yy_current_buffer->yy_eof_status = EOF_PENDING;
	    }
	}

    else
	ret_val = EOB_ACT_CONTINUE_SCAN;

    yy_n_chars += number_to_move;
    yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
    yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

    /* yytext begins at the second character in yy_ch_buf; the first
     * character is the one which preceded it before reading in the latest
     * buffer; it needs to be kept around in case it's a newline, so
     * yy_get_previous_state() will have with '^' rules active
     */

    yytext = &yy_current_buffer->yy_ch_buf[1];

    return ( ret_val );
    }


/* yy_get_previous_state - get the state just before the EOB char was reached
 *
 * synopsis
 *     yy_state_type yy_get_previous_state();
 */

static yy_state_type yy_get_previous_state()

    {
    register yy_state_type yy_current_state;
    register YY_CHAR *yy_cp;

    yy_current_state = yy_start;

    for ( yy_cp = yytext + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
	{
	register YY_CHAR yy_c = (*yy_cp ? yy_ec[*yy_cp] : 1);
	if ( yy_accept[yy_current_state] )
	    {
	    yy_last_accepting_state = yy_current_state;
	    yy_last_accepting_cpos = yy_cp;
	    }
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
	    {
	    yy_current_state = yy_def[yy_current_state];
	    if ( yy_current_state >= 97 )
		yy_c = yy_meta[yy_c];
	    }
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	}

    return ( yy_current_state );
    }


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *     next_state = yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static yy_state_type yy_try_NUL_trans( register yy_state_type yy_current_state )
#else
static yy_state_type yy_try_NUL_trans( yy_current_state )
register yy_state_type yy_current_state;
#endif

    {
    register int yy_is_jam;
    register YY_CHAR *yy_cp = yy_c_buf_p;

    register YY_CHAR yy_c = 1;
    if ( yy_accept[yy_current_state] )
	{
	yy_last_accepting_state = yy_current_state;
	yy_last_accepting_cpos = yy_cp;
	}
    while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
	{
	yy_current_state = yy_def[yy_current_state];
	if ( yy_current_state >= 97 )
	    yy_c = yy_meta[yy_c];
	}
    yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
    yy_is_jam = (yy_base[yy_current_state] == 147);

    return ( yy_is_jam ? 0 : yy_current_state );
    }


#ifdef YY_USE_PROTOS
static void yyunput( YY_CHAR c, register YY_CHAR *yy_bp )
#else
static void yyunput( c, yy_bp )
YY_CHAR c;
register YY_CHAR *yy_bp;
#endif

    {
    register YY_CHAR *yy_cp = yy_c_buf_p;

    /* undo effects of setting up yytext */
    *yy_cp = yy_hold_char;

    if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
	{ /* need to shift things up to make room */
	register int number_to_move = yy_n_chars + 2; /* +2 for EOB chars */
	register YY_CHAR *dest =
	    &yy_current_buffer->yy_ch_buf[yy_current_buffer->yy_buf_size + 2];
	register YY_CHAR *source =
	    &yy_current_buffer->yy_ch_buf[number_to_move];

	while ( source > yy_current_buffer->yy_ch_buf )
	    *--dest = *--source;

	yy_cp += dest - source;
	yy_bp += dest - source;
	yy_n_chars = yy_current_buffer->yy_buf_size;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
	    YY_FATAL_ERROR( "flex scanner push-back overflow" );
	}

    if ( yy_cp > yy_bp && yy_cp[-1] == '\n' )
	yy_cp[-2] = '\n';

    *--yy_cp = c;

    /* note: the formal parameter *must* be called "yy_bp" for this
     *       macro to now work correctly
     */
    YY_DO_BEFORE_ACTION; /* set up yytext again */
    }


#ifdef __cplusplus
static int yyinput()
#else
static int input()
#endif

    {
    int c;
    YY_CHAR *yy_cp = yy_c_buf_p;

    *yy_cp = yy_hold_char;

    if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
	{
	/* yy_c_buf_p now points to the character we want to return.
	 * If this occurs *before* the EOB characters, then it's a
	 * valid NUL; if not, then we've hit the end of the buffer.
	 */
	if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
	    /* this was really a NUL */
	    *yy_c_buf_p = '\0';

	else
	    { /* need more input */
	    yytext = yy_c_buf_p;
	    ++yy_c_buf_p;

	    switch ( yy_get_next_buffer() )
		{
		case EOB_ACT_END_OF_FILE:
		    {
		    if ( yywrap() )
			{
			yy_c_buf_p = yytext + YY_MORE_ADJ;
			return ( EOF );
			}

		    YY_NEW_FILE;

#ifdef __cplusplus
		    return ( yyinput() );
#else
		    return ( input() );
#endif
		    }
		    break;

		case EOB_ACT_CONTINUE_SCAN:
		    yy_c_buf_p = yytext + YY_MORE_ADJ;
		    break;

		case EOB_ACT_LAST_MATCH:
#ifdef __cplusplus
		    YY_FATAL_ERROR( "unexpected last match in yyinput()" );
#else
		    YY_FATAL_ERROR( "unexpected last match in input()" );
#endif
		}
	    }
	}

    c = *yy_c_buf_p;
    yy_hold_char = *++yy_c_buf_p;

    return ( c );
    }


#ifdef YY_USE_PROTOS
void yyrestart( FILE *input_file )
#else
void yyrestart( input_file )
FILE *input_file;
#endif

    {
    yy_init_buffer( yy_current_buffer, input_file );
    yy_load_buffer_state();
    }


#ifdef YY_USE_PROTOS
void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif

    {
    if ( yy_current_buffer == new_buffer )
	return;

    if ( yy_current_buffer )
	{
	/* flush out information for old buffer */
	*yy_c_buf_p = yy_hold_char;
	yy_current_buffer->yy_buf_pos = yy_c_buf_p;
	yy_current_buffer->yy_n_chars = yy_n_chars;
	}

    yy_current_buffer = new_buffer;
    yy_load_buffer_state();

    /* we don't actually know whether we did this switch during
     * EOF (yywrap()) processing, but the only time this flag
     * is looked at is after yywrap() is called, so it's safe
     * to go ahead and always set it.
     */
    yy_did_buffer_switch_on_eof = 1;
    }


#ifdef YY_USE_PROTOS
void yy_load_buffer_state( void )
#else
void yy_load_buffer_state()
#endif

    {
    yy_n_chars = yy_current_buffer->yy_n_chars;
    yytext = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
    yyin = yy_current_buffer->yy_input_file;
    yy_hold_char = *yy_c_buf_p;
    }


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
#endif

    {
    YY_BUFFER_STATE b;

    b = (YY_BUFFER_STATE) malloc( sizeof( struct yy_buffer_state ) );

    if ( ! b )
	YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

    b->yy_buf_size = size;

    /* yy_ch_buf has to be 2 characters longer than the size given because
     * we need to put in 2 end-of-buffer characters.
     */
    b->yy_ch_buf = (YY_CHAR *) malloc( (unsigned) (b->yy_buf_size + 2) );

    if ( ! b->yy_ch_buf )
	YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

    yy_init_buffer( b, file );

    return ( b );
    }


#ifdef YY_USE_PROTOS
void yy_delete_buffer( YY_BUFFER_STATE b )
#else
void yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif

    {
    if ( b == yy_current_buffer )
	yy_current_buffer = (YY_BUFFER_STATE) 0;

    free( (char *) b->yy_ch_buf );
    free( (char *) b );
    }


#ifdef YY_USE_PROTOS
void yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif

    {
    b->yy_input_file = file;

    /* we put in the '\n' and start reading from [1] so that an
     * initial match-at-newline will be true.
     */

    b->yy_ch_buf[0] = '\n';
    b->yy_n_chars = 1;

    /* we always need two end-of-buffer characters.  The first causes
     * a transition to the end-of-buffer state.  The second causes
     * a jam in that state.
     */
    b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;
    b->yy_ch_buf[2] = YY_END_OF_BUFFER_CHAR;

    b->yy_buf_pos = &b->yy_ch_buf[1];

    b->yy_eof_status = EOF_NOT_SEEN;
    }
# line 187 "clexer.l"


#undef yywrap

int yywrap() { return 1;}

/* Skip over comments. */
skipcomments()
{
    char c;

    while (1) {
        while ((c = input()) != '*')
            if (c == '\n') {
                column = 0;
                linenum++;
            }
            else if (c == '\t')
                column += 8 - (column % 8);
            else
                column++;
        if ((c = input()) == '/') {
            column++;
#ifdef LEXDEBUG
    printf ("symbol found: %s\n", "*/");
#endif
            return;
        }
        unput(c);
    }
}

/*ARGSUSED*/
counter(notwhite)
int notwhite;
{
    register char *s;

#ifdef LEXDEBUG
    if (notwhite)
        printf ("symbol found: %s\n", yytext);
#endif
    for (s = yytext; *s; s++)
        if (*s == '\n') {
            column = 0;
            linenum++;
        }
        else if (*s == '\t')
            column += 8 - (column % 8);
        else
            column++;
}

yyerror(s)
char   *s;
{
    fprintf (stderr, "YYERROR: %s: line %d col %d\n", s, linenum, column);
    fprintf (stderr, "YYERROR: yytext=`%s' symbol was (%d)\n", yytext, yychar);
}

#ifdef __STDC__
void quotechar(char c)
#else
void quotechar(c)
char c;
#endif  __STDC__
{
    /* add the quoted character (previous was a '\\') to the global flex */
    /* string token buffer. */

    char s[4];

    if (c == '\n')                      /* newline - put in directly */
        addtostring("\n",1);
    else {
        sprintf(s,"\\%c",c);            /* others - restore '\\' */
        addtostring(s,2);
    }

}  /* end of quotechar() */

#ifdef __STDC__
void addtostring(const char *txt,int txtlen)
#else
void addtostring(txt,txtlen)
char *txt;
int txtlen;
#endif  /* __STDC__ */
{
    /* add the string fragment to the global flex string token buffer. */
    /* clear the buffer if the text length is 0. */

    if (txtlen == 0) {                  /* reset string buffer */
        lexstringtoklen = 0;
    }
    else if (txtlen + lexstringtoklen >= MAXSTRINGLEN) {
        fprintf(stderr,
                "Maximum string token length exceeded - string discarded.\n");
        lexstringtoklen = 0;
    }
    else {                              /* remember the text */
        strncpy(lexstringtok + lexstringtoklen,txt,txtlen);
        lexstringtoklen += txtlen;
    }
    lexstringtok[lexstringtoklen] = '\0';  /* legal C string */

}  /* end of addtostring() */
