Listing 1
---------

/* -----------------------------------------------------------------------

    int MatchWild (const char * wildstr, const char * candstr)

    Match candidate string to wildcard string containing any number
    of '*' or '?' wildcard characters.  The '*' matches any number of
    characters, including zero characters.  The '?' matches exactly
    one character.  Returns 1 if there is a match, else 0.

    Benchmarks for Pentium/60:

      WILDCARD STRING        CANDIDATE STRING          Microsecs.
        asdfghjkl              asdfghjkl                  1.5
        *asdfgh                XXXasdfgh                  2.0
        asdfgh*                asdfghXXX                  1.8
        *aaa*bbb*ccc*          XaaaXXbbbcccXXX            4.1
        asd??fgh??*            asdXXfghXX                 2.7
        *aa??a*bbb             XXaaXXaXXbbXaaXXabbb       5.5

*/


int MatchWild(const char * pWild, const char * pString)
{
   int   ii, star;

new_segment:

   star = 0;
   while (pWild[0] == '*')
   {
      star = 1;
      pWild++;
   }

test_match:

   for (ii = 0; pWild[ii] && (pWild[ii] != '*'); ii++)
   {
      if (pWild[ii] != pString[ii])
      {
         if (! pString[ii]) return 0;
         if (pWild[ii] == '?') continue;
         if (! star) return 0;
         pString++;
         goto test_match;
      }
   }

   if (pWild[ii] == '*')
   {
      pString += ii;
      pWild += ii;
      goto new_segment;
   }

   if (! pString[ii]) return 1;
   if (ii && pWild[ii-1] == '*') return 1;
   if (! star) return 0;
   pString++;
   goto test_match;
}


