#include <stdio.h>
#include "gui.h"

#define MY_EXIT   1
#define MY_NEW    2
#define MY_CLOSE  3
#define MY_TEXT   4
#define MY_NAME   5

class MY_BUTTON: public GUI_BUTTON {
    public:
        MY_BUTTON(GUI_WINDOW *pParent, int id, int x=0, int y=0,
                   int width=MAX_X, int height=MAX_Y, char *text="")
                 :GUI_BUTTON(pParent, id, x, y, width, height, text) {}
        int Activate(void);
        int RightClick(void);
};

class MY_ENTRY: public GUI_ENTRY {
   public:
        MY_ENTRY(GUI_WINDOW* pParent, int id, int x=0, int y=0,
                   int width=MAX_X, int height=0,
                   char* text="", int length=10)
                :GUI_ENTRY(pParent, id, x, y, width, height, text, length) {}
        int Activate(void);
};

GUI_APPLICATION *pApplication;

void CreateMyWindow(int id);
void DeleteMyWindow(GUI_WINDOW *pWindow);

void main(int argc, char **argv)
{
   pApplication = new GUI_APPLICATION(&argc, argv, "demo.log");
   CreateMyWindow(1);
   pApplication->MainLoop();
   delete pApplication;
}

int MY_BUTTON::Activate(void)
{
   static int windowCount = 1;

   switch(GetId() - pParent->GetId()) {
   case MY_EXIT:
      pApplication->Terminate();
      break;
   case MY_NEW:
      if(windowCount < 10) {
         CreateMyWindow(pParent->GetId() + 100);
         windowCount++;
      }
      else {
         GetParent()->Message("Application message", "Too many windows");
      }
      break;
   case MY_CLOSE:
      if(--windowCount) DeleteMyWindow(GetParent());
      else              pApplication->Terminate();
      break;
   }
   return(0);
}

int MY_BUTTON::RightClick(void)
{
   GetParent()->Message("Applicaton Message", "RightClick");
   return(0);
}

int MY_ENTRY::Activate(void)
{
   char text[20+1];

   GetText(text, 20);
   GetParent()->SetText(text);
   return(0);
}

void CreateMyWindow(int id)
{
   int        color, childId;
   char       title[100];
   GUI_WINDOW *pWindow;

   color = id / 100;
   sprintf(title, "Window %d", id);
   pWindow = new GUI_WINDOW(pApplication, id, 15*id, 4900 - 10*id,
                            5000, 5000, color, title,
                            FRAME_TITLE | FRAME_SIZEABLE | FRAME_MAX_BUTTON);

   // create buttons, text and entry field
   new MY_BUTTON(pWindow, id+MY_EXIT,  1000, 9000, 2000, 0, "Exit");
   new MY_BUTTON(pWindow, id+MY_CLOSE, 4000, 9000, 2000, 0, "Close");
   new MY_BUTTON(pWindow, id+MY_NEW,   7000, 9000, 2000, 0, "New");
   new GUI_TEXT(pWindow,  id+MY_TEXT,  1000, 7500, 2500, 0, "New title:");
   new MY_ENTRY(pWindow,  id+MY_NAME,  4000, 7500, 2000, 0, "", 20);

   // create little figure
   childId = id + MY_NAME;
   //body
   new GUI_LINE(pWindow, ++childId, 7500, 7000, 8000, 6500, color+1, 2);
   new GUI_LINE(pWindow, ++childId, 8500, 7000, 8000, 6500, color+1, 2);
   new GUI_LINE(pWindow, ++childId, 8000, 6500, 8000, 4000, color+1, 2);
   new GUI_LINE(pWindow, ++childId, 7500, 5000, 8000, 4500, color+1, 2);
   new GUI_LINE(pWindow, ++childId, 8500, 5000, 8000, 4500, color+1, 2);
   //left eye
   new GUI_ELLIPSE(pWindow, ++childId, 7700, 2900, 300, 300, color+2,
                  FILL_SOLID);
   //right eye
   new GUI_ELLIPSE(pWindow, ++childId, 8300, 2900, 300, 300, color+2,
                  FILL_SOLID);
   //nose
   new GUI_LINE(pWindow, ++childId, 8000, 3200, 8000, 3600, color+2, 1);
   //mouth
   new GUI_LINE(pWindow, ++childId, 7900, 3800, 8100, 3800, color+2, 1);
   new GUI_LINE(pWindow, ++childId, 7800, 3700, 7900, 3800, color+2, 1);
   new GUI_LINE(pWindow, ++childId, 8100, 3800, 8200, 3700, color+2, 1);
   //head
   new GUI_ELLIPSE(pWindow, ++childId, 8000, 3200, 1400, 1600, color+1,
                  FILL_SOLID);

   pWindow->Show();
}

void DeleteMyWindow(GUI_WINDOW *pWindow)
{
   int        id;
   GUI_OBJECT *pObj;

   for(id = MY_EXIT + pWindow->GetId(); pObj = pWindow->GetChildFromId(id) ;
       id++) delete pObj;
   delete pWindow;
}
