#ifndef SIGAWARE_HPP
   #define SIGAWARE_HPP

   // POSIX headers

#include <unistd.h>
#include <signal.h>

   // STL headers

#include <set.h>

   // forward decl of class SigAware for typedefs

class SigAware;

   // typedef a set for SigAware object pointers

typedef set<SigAware *, less<SigAware *> > SigAwarePtrSet;

class SigAware
{

   public:
 SigAware();
 virtual ~SigAware();
 void registerForSignals(SigAware *pSigAware);
 void unregisterForSignals(SigAware *pSigAware);
 virtual void sighandler(int iSig)=0;
 static void sigRouter(int iSig);

   private:
    // the sequence to hold the SigAware pointers
    // to registered objects.
 static SigAwarePtrSet ptrSet;
 static SigAwarePtrSet::iterator i;

}; // end class SigAware

   // SigAware statics follow

SigAwarePtrSet SigAware::ptrSet;
SigAwarePtrSet::iterator SigAware::i;

   // SigAware methods follow

SigAware::SigAware()
{
    // when this constructor is called, 
    // simply register the newly allocated object.
    // This ctor will be called after the 
    // derived class object has been allocated,
    // so that "this" points to a derived class object,
    // which is the behavior we want for our virtuals

 registerForSignals(this);
}

SigAware::~SigAware()
{
 unregisterForSignals(this);
}

void SigAware::registerForSignals(SigAware *pSigAware)
{
    // add the pointer to the set
 ptrSet.insert(pSigAware);
}

void SigAware::unregisterForSignals(SigAware *pSigAware)
{
    // erase the pointer from the set
 ptrSet.erase(pSigAware);
}

void SigAware::sigRouter(int iSig)
{
    // iterate through the set
 for (i=ptrSet.begin(); i != ptrSet.end(); i++)
 {
     // call sighandler on each object
  (*i)->sighandler(iSig);
 }
}    

#endif // SIGAWARE_HPP
