// ISRTHUNK.H
// Thunking code for interrupts.
// D.G. Taylor 1996.

#ifndef ISRTHUNK_H
#define ISRTHUNK_H
#include   <dos.h>    // for definitions.
#include   <hmemory.h>

#ifdef __cplusplus
#define __CPPARGS   ...
#else
#define __CPPARGS
#endif

typedef struct     {
         unsigned char *pbCodeDataStack;
         unsigned uIntNumber;
         BOOL      bActivated;
         void  interrupt (*pfPrevHandler)(void);
         void  interrupt (*pfThunkHandler)(void);
         } ISRTHUNK;

// Put the following macro in as the arguments to the ISR.
// eg void interrupt MyIsr(THUNKARGS)

#define  THUNKARGS  unsigned bp,unsigned di,unsigned si,\
             unsigned ds,unsigned es,unsigned dx,\
             unsigned cx,unsigned bx,unsigned ax,\
             unsigned ip,unsigned cs,unsigned flags,\
             void far *pobject
#ifdef __cplusplus
extern "C" {
#endif

BOOL ISRThunkCreate(ISRTHUNK **ppThunk,unsigned uIntno,
     void interrupt (*pfISRHandler)(__CPPARGS),void *pISRObject,
     unsigned uStacksize);
void ISRThunkActivate(ISRTHUNK *pThunk);
void ISRThunkSuspend(ISRTHUNK  *pThunk);
void ISRCallOldISR(ISRTHUNK  *pThunk);
void ISRChainOldISR(ISRTHUNK *pThunk);
void ISRThunkDestroy(ISRTHUNK *pThunk);


#ifdef __cplusplus
}
#endif

#endif
//===========================EOF isrthunk.h ========================

//    hmemory.h
//    Customised memory allocation functions.

#ifndef HMEMORY_H
#define HMEMORY_H
#include  <stdlib.h>    // for the definition of size_t
#include  <assert.h>
#define   ASSERT   assert

// A few handy types
typedef unsigned BOOL;
#define  TRUE    1
#define  FALSE    0
typedef unsigned char BYTE;

#ifdef __cplusplus
extern "C" {
#endif //__cplusplus

BOOL HeapAlloc(void **ppv,size_t size);
void HeapFree(void *pv);
BOOL HeapValidPointer(void *pv,size_t size);

#ifdef __cplusplus
}
#endif    //__cplusplus

#endif     // HMEMORY_H
//=======================EOF hmemory.h ==============================

