//******************************************************************************
//
//  Name:  PipeSet.h
//
//  Description:  The class PipingSet is used to control the servo and solonoid
//                valves in a 7010 Piping set.  This implementation is designed
//                to work with the piping set hooked up to a DAS1600 AIO board.
//                The computer board's Universal Library will be used to do the
//                board I/O.
//
//******************************************************************************
#ifndef _PIPESET_H_
#define _PIPESET_H_

#include "pid_cntl.h"
#include "pres_sen.h"
#include "ucos.h"

#define SERVO_VALVE_CHAN   0

#define PIPE_SET_SUCCESS               0
#define PIPE_SET_INVALID_SERVO_VOLTS   -1

#define PIPE_MEASURE		0
#define PIPE_CONTROL		1

#define CONTROL_STACK_SIZE  4096

class PipingSet : public PidControl {
   public:
      PipingSet( double kP, double kI, double kD, double lI, double cD );
      int SetServoVoltage( float voltage );
      void StartControl( PressureSensor *sensor );
      void StopControl();
      void SetSetpoint( double SetPoint );
      void SetFullScale( float full_scale, bool highVoltage = false );
      float GetFullScale() { return FullScale; }
      int  GetMode() { return CurrentMode; }
   private:
      int Board;
      float FullScale;
      int  CurrentMode;
      void ControlTask( void );
      static void StartControlTask( void *PipeSetInstance );
      PressureSensor *controlSensor;
      OS_EVENT  *mbox;
      UBYTE TaskStack[CONTROL_STACK_SIZE];
   };
#endif
