Listing 2

/*
Binary-to-Decimal as
Template Metaprogram
*/

template< unsigned long N > struct Bin
  {
  enum { value = (N % 10) + 
           2 * Bin< N / 10 > :: value } ;
  } ;

struct Bin< 0 >
  {
  enum { value = 0 } ;
  } ;

/*
Corresponding ML code
fun Bin( 0 ) = 0 |
    Bin( n ) = n mod 10 + 2 * Bin( n div 10 ) ;
*/
