class DigOutAuditor : public Auditor
{
    const int digOutId_;
    const Address outputA_, outputAfeedBack_, outputB_,
          outputBfeedBack_;
    DigitalOutput *client_;

public:
    void refresh() {
    Bool aState = Global::false,
        aTmpState = Global::true,
        bState = Global::false,
        bTmpState = Global::true;
    Auditor::refresh();

    const Time time = mtime();
    if( time > 
        lastDigOutTest[ digOutId_ ] + Global::doTestInterval )
    {
        lastDigOutTest[ digOutId_ ] = time;

        Bool tmpState1 = readDigital( outputBfeedBack_ );
        writeDigital( outputA_, Global::false );
        Bool tmpState2 = readDigital( outputBfeedBack_ );
        aState = readDigital( outputAfeedBack_ );
        writeDigital( outputA_, client_->state() );
        if( tmpState1 != tmpState2 )
        aTmpState = Global::false;
        
        tmpState1 = readDigital( outputAfeedBack_ );
        writeDigital( outputB_, Global::false );
        tmpState2 = readDigital( outputAfeedBack_ );
        bState = readDigital( outputBfeedBack_ );
        writeDigital( outputB_, client_->state() );
        if( tmpState1 != tmpState2 )
        bTmpState = Global::false;
    }

    if( aState || bState || !aTmpState || !bTmpState ) {
        fault();
        client_->fault();
    } else
        refresh();
    }
};
