class DigitalOutput
{
    friend MasterRun;
    const Address outputA_, outputB_;
    Time lastReset_;
    Auditor *auditor_;
    Bool safe_;

    void state( const Bool& state ) {
    safe_ = state;
    writeDigital( outputA_, safe_ );
    writeDigital( outputB_, safe_ );
    auditor_->refresh();
    }
    void reset() {
    const Time time = mtime();
    if( time > lastReset_ + Global::resetHoldoff )
        state( Global::true );
    else
        state( Global::false );

    lastReset_ = time;
    }

public:
    Bool state() const { return safe_; }
    void safe() {
    if( safe_ )
        auditor_->refresh();
    else
        state( safe_ );
    }
    void fault() {
    state( Global::false );
    }
};
