class Auditor
{
    friend MasterRun;
    Bool safe_;
    Time lastReset_, lastRefresh_, lastWatch_;

    void reset() {
    const Time time = mtime();
    if( time > lastReset_ + Global::resetHoldoff ) {
        safe_ = Global::true;
        lastWatch_ = lastRefresh_ = time;
    }
    lastReset_ = time;
    }

public:
    void refresh() {
    const Time time = mtime();
    if( time > lastRefresh_ + Global::auditInterval )
        safe_ = Global::false;
    lastRefresh_ = time;
    }
    void fault()        { safe_ = Global::false; }
    Bool watchDogCheck() {
    const Time time = mtime();
    if( time > lastWatch_ + Global::watchInterval ||
        time > lastRefresh_ + Global::auditInterval )
        safe_ = Global::false;

    lastWatch_ = time;
    return safe_;
    }
};

class WatchDog
{
    friend MasterRun;
    Bool safe_;
    Time lastReset_;
    Auditor **auditor_;
    const Address output_;

    void reset() {
    const Time time = mtime();
    if( time > lastReset_ + Global::resetHoldoff ) {
        safe_ = Global::true;
    }
    lastReset_ = time;
    }
    void run() {
    while( 1 ) {
        for( int i=0; auditor_[i]; ++i )
        safe_ &= auditor_[i]->watchDogCheck();
        
        writeDigital( output_, safe_ );
        msleep( Global::wdPulseInterval );
        writeDigital( output_, Global::false );
    }
    }
};
