LISTING 6 - Implementation of Stopwatch Functions
/* timer.c:     Stopwatch Functions */

#include <time.h>
#include "timer.h"

static clock_t start = (clock_t) 0;

/* Reset the timer */
void timer_reset(void)
{
    start = clock();
}

/* Wait a number of seconds */
void timer_wait(double secs)
{
    clock_t stop = clock() +
	(clock_t) (secs * CLOCKS_PER_SEC);
    while (clock() < stop);
	;
}

/* Compute elapsed time in seconds */
double timer_elapsed(void)
{
    return (double)(clock() - start) / CLOCKS_PER_SEC;
}

