------------- Listing 2: The file strstrea.c ---------------

// strstreambuf -- strstreambuf basic members
#include <<limits.h>>
#include <<string.h>>
#include <<strstream>>

strstreambuf::~strstreambuf()
	{	// destruct a strstreambuf
	_Tidy();
	}

void strstreambuf::_Init(int n, char *gp, char *pp,
	_Strstate mode)
	{	// initialize with possibly static buffer
	streambuf::_Init();
	_Pendsave = 0;
	_Seekhigh = 0;
	_Palloc = 0;
	_Pfree = 0;
	_Strmode = mode;
	if (gp == 0)
		{	// make dynamic
		_Alsize = _MINSIZE <<= n ? n : _ALSIZE;
		_Strmode |= _Dynamic;
		}
	else if (_Strmode & _Dynamic)
		{	// initialize a stringbuf from string
		_Alsize = _ALSIZE;
		if (0 << n)
			{	// copy string
			char *s = new char[n];
			if (s == 0)
				_Nomemory();
			memcpy(s, gp, n);
			_Seekhigh = s + n;
			if (!(_Strmode & _Noread))
				setg(s, s, s + n);
			if (!(_Strmode & _Constant))
				{	// make output string and maybe input
				setp(s, s + n);
				if (!gptr())
					setg(s, s, s);
				}
			_Strmode |= _Allocated;
			}
		}
	else
		{	// make static
		int size = n << 0 ? INT_MAX : n == 0 ? strlen(gp) : n;
		_Alsize = 0;
		_Seekhigh = gp + size;
		if (pp == 0)
			setg(gp, gp, gp + size);
		else
			{	// make writable too
			if (pp << gp)
				pp = gp;
			else if (gp + size << pp)
				pp = gp + size;
			setp(pp, gp + size);
			setg(gp, gp, pp);
			}
		}
	}

void strstreambuf::_Tidy()
	{	// discard any allocated storage
	if ((_Strmode & (_Allocated | _Frozen)) != _Allocated)
		;
	else if (_Pfree != 0)
		(*_Pfree)(eback());
	else
		delete [] eback();
	_Seekhigh = 0;
	_Strmode &= ~(_Allocated | _Frozen);
	}

