//File: Printers.hpp
#ifndef PRINTERS_HPP
#define PRINTERS_HPP
#include <stdio.h>
#include <windows.h>

const int MaxPrnNameLen = 200;

class BasePrinter {
// Abstract Printer base Class
// Defines minimum functionality and
// default actions for all derrived Printer
// Classes


   public:
      virtual ~BasePrinter() {};
      // Printer function Return codes
      enum PrinterRetCode {
      	FUNC_NOT_SUPPORTED,
      	SUCCESS,
         FAIL} ;

//    ===========================================
// 	Note: PrintLine() and EjectPaper() are
// 	redefined by all derrived classes.
//  	All other functions are optional.
      virtual PrinterRetCode
		PrintLine(char []="")=0; //Print string
      					  	 //Append Carriage Return
   	virtual void EjectPaper(void)=0; //FormFeed
//    ===========================================

      virtual PrinterRetCode
      	SetFontPointSize(unsigned PointSize)
         {return FUNC_NOT_SUPPORTED;};

      void static EnumPrinters(BOOL Display = TRUE,
      		char* ReturnDefPrinter=NULL);
};


class DirectPrinter: public BasePrinter {
// No nonsence direct printer connection
// Using a stream handle to the printer device.
   private:
   	FILE *fPrinter;
	public:
   	DirectPrinter(char* Name="LPT1:");
      ~DirectPrinter();

      PrinterRetCode
      PrintLine(char* = "");

     	void EjectPaper(void);
   };


class WinDirPrinter: public BasePrinter{
// Windows GDI "Passthrough" Printer connection
	private:
      HANDLE hPrinter;
      DWORD ErrorCode;
   	char PrinterName[MaxPrnNameLen+1];
      BOOL PageInitialized;
	public:
   	WinDirPrinter(char* Name=NULL);
      ~WinDirPrinter();

      virtual PrinterRetCode
         PrintLine(char []="");

      virtual void EjectPaper(void);

	};

class WinGDIPrinter: public BasePrinter{
// Windows Printer Connection
// Using the GDI to render the text fonts

	private:
   	HDC hDC;  // Device Context for Printer
   	char PrinterName[MaxPrnNameLen+1];
      int HorizDevRes; // #Horiz dots per page
      int VertDevRes;  // #Vertical dots per page
      int VertPixelsPerInch;

      DOCINFO di;
      int DocValid;  // let me know if EndDoc
      					// should be called

      // Page statistics in pixels
      int CurYOffset;
      int MaxYOffset;
      int FontYSize;

		// Handle to current Font and
      // Font Attributes
      HFONT hFont;
      LOGFONT FontAttrib;

      HFONT hStartFont;  // Original Font at start
      						// of program
		BOOL PageInitialized;
      void CalcLinesPerPage(void);
	public:
      WinGDIPrinter(char *Name=NULL);
      ~WinGDIPrinter(void);

      virtual PrinterRetCode
         PrintLine(char []="");

   	virtual void EjectPaper(void);

      PrinterRetCode ChooseFont(void);

      PrinterRetCode
      SetFontPointSize(unsigned PointSize);
};

#endif
