// Hopefully the names of data members and methods should be
// self-explanatory.
class TrisField : public wxCanvas, public wxTimer {
  TrisCell *cells[TRIS_X][TRIS_Y];
  TrisPiece *currentPiece;
  int tickTime;
  Bool ignoreTickTime;
  wxButton *pauseButton;
  ScoreObj *score;
  LevelObj *level;
  int pieceCount;
public:
  TrisField(wxWindow *parent); // Constructor.
  int TickTime(void);
  void DoResize(int w, int h);
  void DrawField(void);
  void OnChar(wxKeyEvent &event);  // Overidden from wxCanvas.
  void OnPaint(void);
  void Notify(void);     // Overridden from wxTimer.
  void EnterPiece(intPair where);
  void DeletePiece(void);
  int InPlay(void);
  int PieceFits(void);
  void DrawPiece(void);
  void ErasePiece(void);
  void LockPiece(void);
  void StripRows(void);
  void StartGame(void);
  void EndGame(void);
};
