[Caption: A generic HTML form processor that returns the list of name-value pairs
to the browser]

// myproc.C - source file for myProcessor
#include <cgi/htmlhelp.h>
#include "myproc.h"

int myProcessor::process(cgiDataList& data)
{
   // write the document type and HTML header
   cgiHTMLHelper html(cout);

   html.contentType();
   html.header("Name-Value Pairs");

   // write the name, value pairs of data
   for (cgiDataList::const_iterator i = data.begin();
        i != data.end(); i++) {
      // the iterator points to the next name, value pair
      const pair<cgiName, cgiValue>& item = *i;

      // write out the (name, value) pairs
      cout << htmlpara << "("
           << item.first.c_str() << ", "
           << item.second.c_str()<< ")" << endl;
   }

   // write the trailer and exit
   html.trailer();

   return 0;	// succeeds
}


