/***********************************************************************

                       CSA Library, Free Evaluation Version 2.2.0 
                                           Release: June 9th 1997 

       Collection of general purpose functions.


                                           Copyright(c) 1994-1997 
                                                          ComBits 
                                                  The Netherlands 
***********************************************************************/

#ifndef __CSTOOLS_H
#define __CSTOOLS_H

#include "csport.h"
#include "string.h"
#include "cscopton.h"



///////////////// String functions /////////////////////////////////////

csCHAR *notabs(csCHAR *s);	  //STRIP tabs. It doesn't expand.
csCHAR *remove_space(csCHAR *s);

inline
csCHAR *str_lower(csCHAR *s) { return pStrlwr(s); }
inline
csCHAR *str_upper(csCHAR *s) { return pStrupr(s); }

csCHAR *filter_string(csCHAR *s,csCHAR *p);
csCHAR *trim_string( csCHAR *s);
void	str_left(    csCHAR *s,  csCHAR *d,int len);
void	str_split(   csCHAR *src,csCHAR ch,csCHAR *frst,csCHAR *last);
csCHAR *str_strip(   csCHAR *s,  csCHAR *f);

csCHAR *string_replace_ones(csCHAR *s,csCHAR *d,csCHAR *r);
int	string_replace(csCHAR *s,csCHAR *d,csCHAR *r);


inline
csCHAR *str_addchar(csCHAR *s,csCHAR c)
{  csCHAR *p=s+strlen(s);  *p++=c; *p=0; return s; }




///////////////// Text Screen functions ////////////////////////////////

void  box(int row,int col,int h,int w,int border,int color);
void  desktop(void);
void  disp_r_xy(int x,int y,csCHAR c, csCHAR color);
void  disp_xy(int x,int y,csCHAR c, csCHAR color);
void  disp_r_xy(int x,int y,csCHAR c);
void  disp_xy(int x,int y,csCHAR c);
int   is_color(void);

#ifdef _CP_001
#include "conio.h"
inline void gotoyx(int y,int x) { gotoxy(x,y); }
#endif

inline int  make_color(int txt,int backg) {return txt|((backg&7)<<4); }

///////////////// Keyboard //////////////////////////////////////////////
void  empty_kb(void);
void  wait(long msec);
void  waitkb(long msec);

///////////////// Numerical functions ///////////////////////////////////
U32   csrand(U32);
void  csrandomize(U32 n);

U32   cssqrtl(U32 l);
U16   cssqrti(U16 i);
U16   next_prime(U16 i);
U32   lrandom(U32 amount);

////// Returns a representation of a POSITIVE long as 'beautified' string.
////// Example: 17456 -> "17.456"

csCHAR *beautify_long(long l,csCHAR *buffer);

///////////////// File related //////////////////////////////////////////
inline long  filesize(csCHAR *name) { return pFilelength(name); }
int   disk(csCHAR *s);
// char *file_ext(csCHAR *naam,csCHAR *ext);
int   file_exist(csCHAR *fnaam);
int   add_path(csCHAR *filen,csCHAR *path);
int   cstmpname(csCHAR *name);
int   name_match_pattern(csCHAR *filename,csCHAR *pattern);

///////////////// Miscellaneous /////////////////////////////////////////
csCHAR *add2point(void *p,long l);
U32    time_stamp(void);
int    bit_masks(U32 l,U32 &off,U16 &shift);

csCHAR *Char2Hex(csCHAR *buffer, csCHAR c);

///////////////// To avoid superfluous type checking ////////////////////////

inline char *csstrcpy(void *s,void *d) { return strcpy((char *)s,(const char *)d);  }
inline int   csstrlen(void *s) { return strlen((const char *)s); }
inline char *csstrcat(void *s,void *d) { return strcat((char *)s,(const char *)d);  }


#ifndef TRUE
#define TRUE	  1
#endif

#ifndef FALSE
#define FALSE	  0
#endif

#define SWAP(x,y)  ((x) ^= (y) ^= (x) ^= (y))
#define ABS(x)	   MAX(x,-(x))
#define MAX(x,y)   (( ((x)>(y)) ? (x):(y)))
#define MIN(x,y)   (( ((x)<(y)) ? (x):(y)))


#include "cscoptof.h"

#endif
