/**********************************************************************

                       CSA Library, Free Evaluation Version 2.1.1 
                                           Release: May 14th 1997 

      Defining some compiler dependend variables,
      indicating compiler, memory model, platform etc..


                                           Copyright(c) 1994-1997 
                                                          ComBits 
                                                  The Netherlands 
***********************************************************************



      _CP_001	   :Borland C++.
      _CP_001a	   :Borland C++ for Dos
      _CP_001b	   :Borland C++ for OS/2
      _CP_001c	   :Borland C++ for Windows 16 bit.
      _CP_001d	   :Borland C++ for Windows 32 bit.

      _CP_002	   :Microsoft Visual C++.
      _CP_002a	   :Microsoft Visual C++ 16 bit Windows.
      _CP_002b	   :Microsoft Visual C++ 32 bit Windows.
      _CP_002c	   :Microsoft Visual C++ 16 bit Dos.

      _CP_003	   :GNU C++.
      _CP_003a	   :GNU C++ for Linux.

      _CP_004	   :Watcom C++ 10.5
      _CP_004a	   :Watcom C++ 10.5 for DOS
      _CP_004b	   :Watcom C++ 10.5 for Windows 16 bit
      _CP_004c	   :Watcom C++ 10.5 for Windows 32 bit
      _CP_004d	   :Watcom C++ 10.5 for OS/2



      _CP_010	   :Compiling for MS-Dos.
      _CP_020	   :Compiling for MS-Windows.
      _CP_021	   :Compiling for MS-Windows 16 bit.
      _CP_022	   :Compiling for MS-Windows 32 bit.
      _CP_030	   :Compiling for UNIX.
      _CP_031	   :Compiling for Linux.
      _CP_040	   :Compiling for OS2

	      NOTE :The _CP_020 & _CP_022 flags are also set for
		    NT console applications.

      _CP_100	   :Flat Memory Model.



************************************************************************/



#ifndef __CSCMPLR_H
#define __CSCMPLR_H



////////////////////////////////////////////////////////////////////////
///////////////////////// Figuring out the compiler type. //////////////
////////////////////////////////////////////////////////////////////////


#ifdef	__BORLANDC__
////////////////////////// Borland C++ ///////////////////////////////////
   #define  _CP_001
   #define  KnownCompiler


 #ifdef __OS2__
   #define _CP_001b
   #define _CP_040
   #define _CP_100
   #define KnownPlatform
 #endif


 #if (defined( __MSDOS__) && !defined(_Windows))
   #define _CP_001a
   #define _CP_010
   #define KnownPlatform
 #endif

 #if (defined(_Windows) && !defined(__WIN32__))
   #define _CP_001c
   #define _CP_020
   #define _CP_021
   #define KnownPlatform
 #endif

 #if defined(__WIN32__)
   #define _CP_001d
   #define _CP_020
   #define _CP_022
   #define _CP_100
   #define KnownPlatform
 #endif




#endif




#ifdef _MSC_VER
////////////////////////// Microssoft C++ ////////////////////////////////
   #define  _CP_002
   #define  KnownCompiler

#if defined(_WIN32)
   // 32 bits
   #define  _CP_002b
   #define  _CP_020
   #define  _CP_022
   #define  _CP_100
   #define KnownPlatform
#endif

#if (!defined(_WIN32) && defined(_WINDOWS))
   // 16 bits Windows
   #define  _CP_002a
   #define  _CP_020
   #define  _CP_021
   #define KnownPlatform
#endif

#if (!defined(_WINDOWS) && !defined(_WIN32))
   // DOS
   #define  _CP_002c
   #define  _CP_010
   #define KnownPlatform
#endif



#endif










#ifdef	 __GNUC__
////////////////////////// GNU C++ ///////////////////////////////////////
   #define  _CP_003
   #define  KnownCompiler
#ifdef __linux__
   #define  _CP_003a
   #define  _CP_100
   #define  _CP_030
   #define  _CP_031
   #define KnownPlatform
#endif

#endif





#ifdef	 __WATCOMC__
////////////////////////// WATCOM C++ /////////////////////////////////////
 #define  _CP_004
 #define  KnownCompiler

 #ifdef __DOS__
   #define _CP_004a
   #define _CP_010
   #define KnownPlatform
 #endif

 #ifdef __WINDOWS__
   #define _CP_004b
   #define _CP_020
   #define _CP_021
   #define KnownPlatform
 #endif

 #ifdef __NT__
   #define _CP_004c
   #define _CP_020
   #define _CP_022
   #define _CP_100

   #undef  _CP_004b
   #undef  _CP_021
   #define KnownPlatform
 #endif

 #ifdef __OS2__
   #define _CP_004d
   #define _CP_040
   #define _CP_100
   #define KnownPlatform
 #endif

#endif




///////////////////////////////////////////////////////////////////////
//////////////////////// Test for a 'Known Compiler '//////////////////
//////////////////////////////////////////////////////////////////////


#ifdef KnownCompiler
   #undef KnownCompiler
#else
   #error UNKNOWN Compiler
#endif





///////////////////////////////////////////////////////////////////////
//////////////////////// Test for a 'Known Platform '//////////////////
//////////////////////////////////////////////////////////////////////


#ifdef KnownPlatform
   #undef KnownPlatform
#else
   #error UNKNOWN Platform
#endif


///////////////////////////////////////////////////////////////////////
//////////////////////// Set OS name //////////////////////////////////
///////////////////////////////////////////////////////////////////////




#ifdef	_CP_010
#define _CP_PLATFORM  "DOS"
#endif

#ifdef	_CP_021
#define _CP_PLATFORM  "Windows (16 bit)"
#endif

#ifdef	_CP_022
#define _CP_PLATFORM  "NT"
#endif

#ifdef	_CP_031
#define _CP_PLATFORM  "Linux"
#endif

#ifdef	_CP_040
#define _CP_PLATFORM  "OS/2"
#endif


#ifndef _CP_PLATFORM
#define _CP_PLATFORM  ""
#endif




#endif

