/***********************************************************************

                                       CSA Library, Version 1.6.b 
                                         Released: March 2nd 1995 

       A WINDOW class for character windows.

                                           Copyright(c) 1994,1995 
                                                           Combis 
                                                  The Netherlands 
***********************************************************************/

#ifndef __CSWINDOW_H
#define __CSWINDOW_H

#ifndef __STDLIB_H
  #include "stdlib.h"
#endif

#ifndef __STRING_H
  #include "string.h"
#endif

#ifndef __CSTOOLS_H
  #include "cstools.h"
#endif

#define W_NEW	       ((int)-17)

#define W_BORDER_SINGLE  BORDER_SINGLE
#define W_BORDER_DOUBLE  BORDER_DOUBLE
#define W_BORDER_SPACE	 BORDER_SPACE
#define W_BORDER_NONE	 BORDER_NONE

#define NO_SHADOW      0
#define SHADOW	       1

#define W_HIDE	    1
#define W_ACTIVE    2



int  _cs_win_calc_dim(int &r,int &c,int &h,int &w,int border_t);
int  win_get_dim(int num,int *row,int *kol,int *ho,int *le);
int  win_get_in_dim(int num,int *row,int *kol,int *ho,int *le);
int  win_work_size(int num,int *ho,int *le);
int  win_make(int& num,int rc,int sc,CSCHAR *kop,int row,int kol, int h, int l,int border,int shadow);
int  win_adjust(int num,int rc,int sc,CSCHAR *kop,int row,int kol, int h, int l,int rand,int shadow);
int  win_remove(int num);
int  win_default(void);
int  win_shift(int num);
int  win_present(int num);
int  win_first_unused(void);
int  win_current(void);
void win_clear(void);
int  win_remove_all(void);
int  win_user_adjust(void);
int  win_scroll(int num,int row,int col);
int  win_previous(void);

/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////
//////////////////////// CLASS defintion ////////////////////////
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////

class WINDOW
{
 protected:
      int auto_del;
      int win_nr;
      int win_border;
      int win_rc;
      int win_sc;
      int win_row;
      int win_col;
      int win_high;
      int win_width;
      CSCHAR win_head[50];
      int win_shadow;

 public:

/////////////////////// Constructor & Destructor ////////////////
      WINDOW(void);
      ~WINDOW(void);

/////////////////////// Appearance & Color //////////////////////
      void border(int w){ win_border=w; }
      void border_color(int w)	  { win_rc=w; }
      void screen_color(int w)	  { win_sc=w; }
      int  border_color(void)	  { return win_rc; }
      int  screen_color(void)	  { return win_sc; }
      void color(int bc,int sc)   { border_color(bc); screen_color(sc); }
      void shadow(int tf)   { win_shadow=tf; }

/////////////////////// Size & Postion //////////////////////////
      void top(int w)	    { win_row=w; }
      void left(int w)	    { win_col=w; }
      void coord(int row,int col) {top(row); left(col); }
      void height(int w)    { win_high=w; }
      int  height(void)     { return win_high; }
      void width(int w)     { win_width=w; }
      int  width(void)	    { return win_width; }
      void work_size(int *h,int *w) { win_work_size(win_nr,h,w); }
      void get_dim(int *row,int *col,int *h,int *w)
				    { win_get_dim(win_nr,row,col,h,w); }
      void get_in_dim(int *row,int *col,int *h,int *w)
				    { win_get_in_dim(win_nr,row,col,h,w); }
      void set_dim(int row,int col,int h,int w);

/////////////////////// Adjusting Size //////////////////////////
      int adjust(void);
      int user_adjust(void);

/////////////////////// Heading /////////////////////////////////
      void head(CSCHAR *s)    { if(strlen(s)<50) strcpy(win_head,s); }

/////////////////////// Browsing ASCII files ////////////////////
      int  browse(CSCHAR *file_name);

/////////////////////// Scrolling ///////////////////////////////
      void scroll(int row,int col) { win_scroll(win_nr,row,col); }

/////////////////////// Working With/In /////////////////////////
      void activate(void);
      void clear(void);

/////////////////////// Switching between windows ///////////////
      int previous(void)    { return win_previous();	}
      int number(void)	    { return win_nr; }

/////////////////////// Removing ////////////////////////////////
      void remove_all(void) { win_remove_all();  }
      void remove(void)     { win_remove(win_nr); win_nr=W_NEW; }

/////////////////////// Miscellaneous ///////////////////////////

      void auto_delete(int tf)	{ auto_del=tf; }


};


#endif
