/***********************************************************************

                                       CSA Library, Version 1.6.b 
                                         Released: March 2nd 1995 

       Header file of the DATE class.
       Also defines date formats.

       NOTE: The julian-date functions require floating point.

                                           Copyright(c) 1994,1995 
                                                           Combis 
                                                  The Netherlands 
***********************************************************************/

#ifndef __CSDATE_H
#define __CSDATE_H


#include "cstools.h"
#include "csjulian.h"

enum f_date  {	MDY2,
		MY2D,
		Y2MD,
		Y2DM,
		DMY2,
		DY2M,
		MDY4,
		MY4D,
		Y4MD,
		Y4DM,
		DMY4,
		DY4M   };




inline int leap_year(int J) {return ((J%400==0) || ((J%4==0) && (J%100!=0))); }
inline int days_in_year(int j) { return 365+leap_year(j); }
int days_in_month(int mo,int year);
int days_in_month(int mo);
int date_validate(CSCHAR *s,int format);
void date_SN(CSCHAR *s,int *x,int *y,int *z);
void parm_ord(int ,int,int,int, int &,int & ,int &);
void default_date_format(int );     // Sets the default format for the DATE.




class DATE
{

private:

  unsigned form :4;	      // Date Format.
  unsigned mo	:4;	      // Month
  unsigned y4	:1;	      // TRUE if 4 digits for the year, FALSE otherwise.
  unsigned da	:5;	      // Day
  int	   ye;		      // Year

protected:

   int year4(int ye);


public:

  S32 sem_jul(void);
  S32 sem_jul(CSCHAR *s);
  S32 sem_jul(uchar *s)       { return sem_jul((CSCHAR *)s); }
  S32 sem_jul(int Y,int M,int D);
 void sem_jul(S32 l);



  void format(int dat_f);  // Set the date format.
   int format(void)	   { return form; }
			   // Returns the date format.
   int day(void)	   { return da; }
			   // Returns the day of the month [1..31]
   int day(CSCHAR *);	   // Returns also the name of the day,
			   // [monday,tuesday,...sunday]
  void day(int d)	   { da=d; }
			   // Sets the day.
   int week_day(void);	   // Returns the day of the week.
			   // Monday=1, Tuesday=2, etc..
   int month(void)	   { return mo; }
			   // Returns the month [1..12]
   int month(CSCHAR *);    // Returns also the name of the calendar month,
			   // [January,February...December]
  void month(int m)	   { mo=m; }
			   // Sets the month.
   int year(void)	   { return ( (y4) ? ye: ye%100); }
			   // Returns the year in 2 or 4 digits, depending
			   // on the format.
  void year(int y)	   {  ye=y; }
			   // Sets the year.
			   // No century data is added or checked!
   int year4(void)	   { return ye; }
			   // Returns the year with a 4 digit format.
   int long_year(void)	   { return y4; }
			   // Returns TRUE if 4 positions are used
			   // to represent the year. FALSE otherwise.
   int leap_year(void)	   {  return ::leap_year(ye); }
			   // Returns TRUE if the date is a leap-year.
			   // FALSE otherwise.
  void julian(long j);	   // Set date according to julian date.
  long julian(void)	   {  return cal_julian(mo,da,year4()); }
			   // Returns Julian date.
   int valid(void);	   // Returns TRUE if the date is a valid
			   // calendar date, FALSE otherwise.
   void now(void);	   // Make date equal to the system clock.


////////////////////// Constructor   /////////////////////////////
   DATE::DATE(void);
   DATE::DATE(CSCHAR *s);

////////////////////// Type casting  /////////////////////////////

   operator CSCHAR*();


////////////////////// Operator overloading /////////////////////


   int operator==(DATE &da)    { return sem_jul()==da.sem_jul(); }
   int operator!=(DATE &da)    { return sem_jul()!=da.sem_jul(); }
   int operator<( DATE &da )   { return sem_jul()<da.sem_jul();  }
   int operator<=(DATE &da )   { return sem_jul()<=da.sem_jul(); }
   int operator>( DATE &da )   { return sem_jul()>da.sem_jul();  }
   int operator>=(DATE &da )   { return sem_jul()>=da.sem_jul(); }
   int operator==(CSCHAR *s)   { return sem_jul()==sem_jul(s); }
   int operator!=(CSCHAR *s)   { return sem_jul()!=sem_jul(s); }
   int operator<( CSCHAR *s )  { return sem_jul()<sem_jul(s);  }
   int operator<=(CSCHAR *s )  { return sem_jul()<=sem_jul(s); }
   int operator>( CSCHAR *s )  { return sem_jul()>sem_jul(s);  }
   int operator>=(CSCHAR *s )  { return sem_jul()>=sem_jul(s); }
   int operator==(uchar *s)    { return sem_jul()==sem_jul(s); }
   int operator!=(uchar *s)    { return sem_jul()!=sem_jul(s); }
   int operator<( uchar *s )   { return sem_jul()<sem_jul(s);  }
   int operator<=(uchar *s )   { return sem_jul()<=sem_jul(s); }
   int operator>( uchar *s )   { return sem_jul()>sem_jul(s);  }
   int operator>=(uchar *s )   { return sem_jul()>=sem_jul(s); }

   DATE&  operator+=(long days);
   DATE&  operator-=(long days)  { return operator+=(-days); }
   DATE&  operator=(DATE &);
    long  operator-(DATE &);
   DATE&  operator=(CSCHAR *);


};


#endif
