/*  CS-HOT version 1.01        Copyright (C) 1993 by Jim Robeson
 *                                                      3/02/93
 *  Function:
 *    Read the output of PCBCS143 (arg-1),
 *      and strip it down to a "hotfile" report (arg-2),
 *      according to the FORMat requested (arg-3).
 *         "FORM" must be 1 or 2 or 3
 *                1 = output only "files downloaded" section
 *                2 = also include the "1st page stats" section
 *                3 = also include the "multi-node" section,
 *                    (if it exists).
 *
 *  Other uses:
 *    None.
 *
 *  Execution:
 *    Run from command line or .BAT:
 *      CS-HOT drv:\path\in-file-name drv:\path\out-file-name FORM
 *    If run without arguments, a bit of help appears.
 *
 *  Compiled with:
 *    Borland's Turbo C 2.0.
 *    tcc cs-hot
 *
 *  Disclaimer:
 *    This program is contributed to the Public Domain.  It can be
 *    freely used, modified and/or distributed by anyone. The only
 *    thing I ask is that you remember that I am not responsible
 *    for anything that might go wrong through the use of this
 *    program.  I have tested the program enough for my own use.
 *    I also realize that bugs can appear in most every program.
 *    Therefore, YOU USE THIS PROGRAM AT YOUR OWN RISK.
 *
 *  To-do:
 *
 *  Enjoy,
 *  Jim Robeson
 *  The Cricket BBS, Pacific Grove CA,  408-373-3773
 */

#include "stdio.h"         /* Standard I/O definitions */
#include "string.h"

#define TRUE 1
#define FALSE 0

void showhelp ( );         /* prototype */

  FILE *infile;            /* the IN file */
  FILE *outfile;           /* the OUT file */
  char inbuf[BUFSIZ];      /* line buffer for reading from file */
                           /* BUFSIZ = 512 in stdio.h */
  int ipt,opt,i;           /* index pointers */
  int phase;
  int linecnt;

char *isitTTL = "            PCB Caller Statistics Version 1.43";
char *isitMLT = "                              Multinode Statistics";
char *isitHOT = "                         Files downloaded --- by Count";

/* ========================================= */
/* ===  MAIN                             === */
/* ========================================= */
main(int argc, char *argv[])       /* main reads command args  */
{
  char *progname;
  char *filein;
  char *fileout;
  char *form;

/*  Display a little how-to "help" if arguments are null or improper  */

  if (argc != 4)           /*  should be 3 args + prognam */
     { if (argc != 1)
         printf("\nERROR: needs 3 arguments\n");
       showhelp();
       exit (1); }               /* exit with errorlevel=1 */

  progname = argv[0];
  filein   = argv[1];
  fileout  = argv[2];
  form     = argv[3];

  if (form[0] == '1' || form[0] == '2' || form[0] == '3') ;
     else
     { printf("\nERROR: FORM MUST = 1, 2 OR 3\n");
       showhelp();
       exit (1); }               /* exit with errorlevel=1 */

  printf("\nCS-HOT IS RUNNING.  Input = %s, Output = %s, FORM = %s.\n",filein,fileout,form);

  infile = fopen(filein,"r");          /* open the input file */
  if (infile == NULL)
    {
    fprintf(stderr,"\n\007%s can't open the INPUT file: %s.\n",progname,filein);
    exit (1);
    }

  outfile = fopen(fileout,"w");          /* open the output file */
  if (outfile == NULL)
    {
    fprintf(stderr,"\n\007%s can't open the OUTPUT file: %s.\n",progname,fileout);
    exit (1);
    }

  phase = 1;
  linecnt = 0;
 /* ========================  copy the file ========================= */
  while ( fgets(inbuf,BUFSIZ,infile) != NULL )  /* TOP-OF-LOOP */
    {

    switch (phase)

      { case 1 :       /* copy the first 3 lines as-is */
          fprintf(outfile,"%s",inbuf);
          linecnt++;
          if (linecnt == 4) phase = 2;
          break;

        case 2 :       /* copy 1st STAT PAGE until next title */
          if ( strncmp(inbuf,isitTTL,strlen(isitTTL)) == 0 )    /* test for Vern's page title */
            { fprintf(outfile,"\n");  /* found it, stuff a blank line */
              phase = 3;
              break;
            }
          if (form[0] == '2' || form[0] == '3')
            fprintf(outfile,"%s",inbuf);
          break;

        case 3 :       /* now, skip to the multi-node section */
          if ( strncmp(inbuf,isitHOT,strlen(isitHOT)) == 0 )    /* test for mulit-node line */
            { fprintf(outfile,"%s",inbuf);    /* write it out */
              phase = 6;
              break;
            }
          if ( strncmp(inbuf,isitMLT,strlen(isitMLT)) == 0 )    /* test for mulit-node line */
            { if (form[0] == '3')
                fprintf(outfile,"%s",inbuf);    /* write it out */
              phase = 4;
              break;
            }
          break;

        case 4 :       /* copy MULTI-NODE report until next title */
          if ( strncmp(inbuf,isitTTL,strlen(isitTTL)) == 0 )    /* test for Vern's page title */
            { fprintf(outfile,"\n");  /* found it, stuff a blank line */
              phase = 5;
              break;
            }
          if (form[0] == '3')
            fprintf(outfile,"%s",inbuf);
          break;

        case 5 :       /* now, skip to the hot-file section */
          if ( strncmp(inbuf,isitHOT,strlen(isitHOT)) == 0 )    /* test for mulit-node line */
            { fprintf(outfile,"%s",inbuf);    /* write it out */
              phase = 6;
              break;
            }
          break;

        case 6 :       /* copy the HOTFILES to end, except page titles */
          if ( strncmp(inbuf,isitTTL,strlen(isitTTL)) == 0 )    /* test for Vern's page title */
             break;
          fprintf(outfile,"%s",inbuf);
          break;

        default:
          fprintf(stderr,"\nYO, HOW DID I GET HERE, OH MASTER?\n");
          exit (1);
      } /* end of switch */

    } /* end of while at TOP-OF-LOOP */

  /* === Since we dropped through,  ============== */
  /* === implies end of file found. ============== */

  fclose(infile);
  fclose(outfile);

  printf("CS-HOT IS FINISHED.\n");
  exit (0);      /* job done, get out, errorvalue = 0 */

}  /* ------------- end of main ------------------------------- */

/* ========================================= */
/* ===  SHOWHELP                         === */
/* ========================================= */
void showhelp ()
{
  printf("\nCS-HOT v1.01:\n");
  printf("    Strip PCBCS reports into a smaller form.\n");
  printf("    by Jim Robeson,  3-02-93\n\n");
  printf("USAGE:\n");
  printf("    CS-HOT drv:\path\in-file-name drv:\path\out-file-name FORM\n");
  return;
}  /* ------------- end of showhelp --------------------------- */

/*------------- End of CS-HOT.C ------------------------------------*/
