{$I-}
{$X- function calls may not be discarded}
UNIT ArcType; {based mostly on a code snippet found in SWAG}
(* A Pascal unit which will determine most major archive types.
   To use this unit, simply call the procedure as follows:
   If GetArcType(FileName.Ext)=ZIP then.... *)

INTERFACE

USES
  DOS;
TYPE
  fileArcType = (FileError, Unknown,
                 ARC, ARJ, HAP, LZH, PAK, RAR, SQZ, UC2, ZIP, ZOO);

FUNCTION GetArcType (FName : STRING) : fileArcType;

IMPLEMENTATION

FUNCTION GetArcType (FName : STRING) : fileArcType;
VAR
  ArcFile : FILE OF BYTE;
  i       : INTEGER;
  Gat     : fileArcType;
  c       : ARRAY [1..7] OF BYTE;
BEGIN
  Assign (ArcFile, FName);
  Reset (ArcFile);
  IF IOResult <> 0 THEN
    Gat := FileError
  ELSE
    IF FileSize (ArcFile) < 5 THEN
      Gat := FileError
    ELSE BEGIN
      FOR i := 1 TO 7 DO
        Read (ArcFile, c [i]);
      Close (ArcFile);

        IF ((c [1] = $53) AND (c [2] = $51) AND (c [3] = $57)) THEN
        Gat := SQZ   {SQWEZ}
      ELSE
        IF ((c [1] = $50) AND (c [2] = $4B) AND (c [3] = $03) AND (c [4] = $04)) THEN
        Gat := ZIP
      ELSE
        IF ((c [1] = $55) AND (c [2] = $43) AND (c [3] = $32) AND (c [4] = $1a)) THEN
        Gat := UC2
      ELSE
        IF ((c [1] = $52) AND (c [2] = $61) AND (c [3] = $72)) THEN
        Gat := Rar
      ELSE
        IF ((c [1] = $91) AND (c [2] = $33) AND (c [3] = $48) AND (c [4] = $46)) THEN
        Gat := HAP   {[3HF}
      ELSE
        IF ((c [1] = $5a) AND (c [2] = $4f) AND (c [3] = $4f)) THEN
        Gat := ZOO   {ZOO - only at beginning on MS-DOS machines!}
      ELSE
        IF ((c [3] = $2d) AND (c [4] = $6c) AND (c [7] = $2d)) THEN
        Gat := LZH   {??-l??-}
      ELSE
        IF ((c [1] = $60) AND (c [2] = $EA)) THEN
        Gat := ARJ
      ELSE
        IF ((c [1] = $1a) AND (c [2] = $08) OR (c [2] = $09)) THEN
        Gat := ARC
      ELSE
        IF ((c [1] = $1a) AND (c [2] >= $0a)) THEN
        Gat := PAK
      ELSE
       {IF none of the above}
        Gat := Unknown;
    END;

  GetArcType := Gat;
END;

END.
