{$I-}
UNIT CPT_COMN;

INTERFACE

USES CRT, DOS, NUMDAYS;

TYPE MemLink = ^MemberRec;
     MemberRec = record
       name   : string[25];
       sent   : word;
       oldest,
       newest : string[8];
       BBS1,
       BBS2   : string[79];
       notes  : string[79];
       next   : MemLink;
     end;

CONST
  version = 'v1.11';
  author  = version+
       ': February 20, 1995. (c) 1995 by David Daniel Anderson - Reign Ware.';

  DelimitLine='=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-='+
              '-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=';

  EndOfDB='>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'+
               ' end of database '+
          '<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<';

  High_Message : string[7]='';

  cursorState : byte = 1;  {0..3}
  cursorData : array [0..3] of char = (#179, #47, #196, #92);

VAR confnumb : word;
    field    : string;
    inverse  : boolean;
    UnArcQWK : pathstr;

{===========================================================================}

procedure WriteError(Const problem: byte);
procedure iocheck(const iores :byte);
procedure cursorOn;
procedure cursorOff;
procedure updateCursor;
procedure WriteMemAvail;
FUNCTION MixCase(s: string): string;
FUNCTION Upper(w: string): string;
function fileexists(const filename:pathstr):boolean;
function Squeeze(const ss:string):string;
function GetNewHigh(const high, current: string): string;
function MiddleOf(const s: string): string;
function GetOriginLine(const origin : string): string;
function GetMFN(const pstr: string): pathstr;
function GetQWKdir(const pstr: string; var QP: pathstr): dirstr;
function BuildList(var list: MemLink; const fname: string): word;
function ReadDAT(var list: MemLink; const DATFileName: string): word;
function Relevant(Const s: string; Const len: byte): string;
procedure GetSortField(Const pstr: string);
function CompareFields(Const cnode, cnode2: MemLink): boolean;
procedure SortLinkedList(var list: MemLink);  {By Ian Lin, found in SWAG}
procedure WriteList(var list: MemLink; Const fname: string; Const mems: word);
procedure WriteStats(var list: MemLink; Const fname: string; Const mems: word);
procedure InitArcQWK;
function ExtractDAT(const DATfile, DATFileName : string): boolean;
procedure EraseFile(const DATfile : string);

{===========================================================================}

IMPLEMENTATION

procedure WriteError(Const problem: byte);
var
  message: string[79];
begin
  case problem of
    1 : message := 'Command line error: two valid parameters must be specified.';
    2 : message := 'No files found.  First parameter must be a valid file specification.';
    3 : message := 'You cannot use ".STT" as the file extension, since .STT is used by CPT-Stat.';
    4 : message := 'Configuration file not found with executable.  Consult the documentation.';
    5 : message := 'Not enough memory to extract MESSAGES.DAT - aborting!';
    6 : message := 'You cannot just specify a path, add "*.*" or "\*.*" for all files.';
    7 : message := 'File handling error.  Original has not been updated, and is possibly corrupt.';
  else  message := 'Unknown error.';
  end;
  writeln (#7, 'Error encountered:'); writeln (message);
end;

procedure iocheck(const iores :byte);
begin
  if iores <> 0 then halt(7);
end;

procedure cursorOn;assembler;asm
  mov ah,3; mov bh,0; int $10; and ch,not $20; mov ah,1; int $10;
end;

procedure cursorOff;assembler;asm
  mov ah,3; mov bh,0; int $10; or ch,$20; mov ah,1; int $10;
end;

procedure updateCursor;
begin
  cursorState := succ(cursorState) and 3;
  write(cursorData[cursorState], ^H);
end;

procedure WriteMemAvail;
begin
  GotoXY(60,WhereY);
  Writeln('RAM free: ',MemAvail);
end;

FUNCTION MixCase(s: string): string;
CONST
  space  = #32;
  hyphen = #45;
  period = #46;
VAR
  cp  : Integer;        {The position of the character to change.}
  s2  : string;
BEGIN
  FOR cp:= 1 TO Length (s) DO
    if s[cp] in ['A'..'Z'] then INC(s[cp],32);

  s[1]:= UpCase (s[1]);  { Capitalize first letter }

  s2:='';
  while Pos(space,s) > 0 do begin  { Capitalize initial letters after spaces }
    s2:=s2+Copy(s,1,(Pos(space,s)));
         Delete(s,1,(Pos(space,s)));
    s[1]:= UpCase (s[1]);
  end;
  if (length(s) >= 3) AND (Copy(s,1,2) = 'Mc') then
    s[3]:=UpCase(s[3]);  { Capitalize third letter of "McKay", etc. }
  if (length(s) = 2) AND (Copy(s,1,2) = 'Ii') then
    s[2]:=UpCase(s[2]);  { Capitalize "II" }
  s2:=s2+s;
  s:=s2;

  s2:='';
  while Pos(hyphen,s) > 0 do begin  { Capitalize initial letters after hypens}
    s2:=s2+Copy(s,1,(Pos(hyphen,s)));
         Delete(s,1,(Pos(hyphen,s)));
    s[1]:= UpCase (s[1]);
  end;
  s2:=s2+s;
  s:=s2;

  s2:='';
  while Pos(period,s) > 0 do begin  { Capitalize initial letters after periods}
    s2:=s2+Copy(s,1,(Pos(period,s)));
         Delete(s,1,(Pos(period,s)));
    s[1]:= UpCase (s[1]);
  end;
  s2:=s2+s;
  s:=s2;

  MixCase:= s;
END;

FUNCTION Upper(w: string): string;
VAR
  cp  : Integer;        {The position of the character to change.}
BEGIN
  FOR cp:= 1 TO Length (w) DO
    w[cp]:= UpCase (w[cp]);
  Upper:= w;
END;

function fileexists(const filename:pathstr):boolean;
var
  attr : word;
  f    : file;
begin
  assign (f, filename);
  getfattr (f, attr);
  fileexists := (DOSerror = 0);
end;

function Squeeze(const ss:string):string;
var
  controlCHAR: char;
  s:string;
begin
  s:=ss;
  for controlCHAR:=#0 to #31 do
  while (ord(s[0]) > 0) and (Pos(controlCHAR,s) > 0) do
    s[Pos(controlCHAR,s)]:=#32;
  while (ord(s[0]) > 0) and (s[1]=#32) do
    delete(s,1,1);
  while (ord(s[0]) > 0) and (s[length(s)]=#32) do
    delete(s,length(s),1);
  Squeeze:=s
end;

function GetNewHigh(const high, current: string): string;
var
  old, new: longint;
  verr: integer;
begin
  Val(Squeeze(high),old,verr);
  Val(Squeeze(current),new,verr);
  if (new > old) then
    GetNewHigh:=Squeeze(current)
  else
    GetNewHigh:=high
end;

function MiddleOf(const s: string): string;
var
  pre_mid, post_mid : byte;
begin
  pre_mid:=5*length(s) div 10;
  post_mid:=6*length(s) div 10;
  MiddleOf:=Copy(s,pre_mid,(post_mid - pre_mid))
end;

function GetOriginLine(const origin : string): string;
var ol : string;
begin
 ol:=origin;
 while (ord(ol[0]) > 0) and (ol[length(ol)] in [#0,#32,#227]) do
   delete (ol,length(ol),1);
 while pos(#227,ol) > 0 do
   delete (ol,1,pos(#227,ol));
 ol:=squeeze(ol);
 if (length(ol) > 78) then
   ol:=copy(ol,1,78);
 GetOriginLine:=#32+ol;
end;

function GetMFN(const pstr: string): pathstr;
var
  MFNpath   : pathstr;    { MFN file path,          }
  MFNdir    : dirstr;     {             directory,  }
  MFNname   : namestr;    {             name,       }
  MFNext    : extstr;     {             extension.  }

  sTemp : string;
  index : byte;
  VErr  : integer;
begin
  MFNpath:=pstr;
  if MFNpath[1] in ['/','-'] then halt(1);
  fsplit(fexpand(MFNpath),MFNdir,MFNname,MFNext);
    if (MFNname = '')  then halt(6);
    if (MFNext = '.STT')  then halt(3);

  sTemp :='';
  for index:=1 to length(MFNname) do
    if MFNname[index] in ['0'..'9'] then
      sTemp:=sTemp+MFNname[index];
  if sTemp='' then halt(1);
  Val(sTemp,confnumb,VErr);  { confnumb is a GLOBAL var }
  if VErr <> 0 then halt(1);

  GetMFN:=MFNdir+MFNname+MFNext;
END;

function GetQWKdir(const pstr: string; var QP: pathstr): dirstr;
VAR
  QWKpath   : pathstr;    { QWK file path,          }
  QWKdir    : dirstr;     {             directory,  }
  QWKname   : namestr;    {             name,       }
  QWKext    : extstr;     {             extension.  }
BEGIN
  QWKpath:=pstr;
  if QWKpath[1] in ['/','-'] then halt(1);
  fsplit(fexpand(QWKpath),QWKdir,QWKname,QWKext);
    if (QWKname = '')  then halt(6);
  QP:=QWKpath;
  GetQWKdir:=QWKdir;
END;
{===========================================================================}

function BuildList(var list: MemLink; const fname: string): word;
CONST
  namepos=3; sentpos=namepos+31; oldestpos=sentpos+14; newestpos=oldestpos+13;
  bbs1pos=1; bbs2pos=1; notespos=7;
VAR
  MemInfo    : string;
  anchor,
  MemberInfo : MemLink;
  infile     : text;
  VErr       : integer;
  Members    : word;
  DataEnd    : boolean;
BEGIN
  write('Reading membership list, please wait ... ');
  DataEnd:=FALSE;
  Members:=0;
  if fileexists(fname) then begin
    assign(infile,fname);
    reset(infile); iocheck(ioresult);
    list:=nil;
    while NOT DataEnd do
    BEGIN
      repeat      { find first separator line }
        readln(infile,MemInfo); iocheck(ioresult);
        if (length(MemInfo) >= 15) AND (Copy(MemInfo,1,14)='High message: ') then
          High_Message:=Copy(MemInfo,15,length(MemInfo)-14);
        if EOF(infile) or (MemInfo=EndOfDB) then DataEnd:=True;
      until DataEnd OR (MemInfo=DelimitLine);
      if not DataEnd then begin  { assume start of new data }

         updatecursor;
         inc(Members);
         new(MemberInfo);
           with MemberInfo^ do BEGIN
             name:='';
             sent:=0;
             oldest:='';
             newest:='';
             BBS1:='';
             BBS2:='';
             notes:='';
             next:=nil;
           END; {with}

         repeat  { fill in new data }
           readln(infile,MemInfo); iocheck(ioresult);
           if EOF(infile) or (MemInfo=EndOfDB) then DataEnd:=True;
           if (not DataEnd) then
             with MemberInfo^ do BEGIN
               if Copy(MemInfo,1,2)=': ' then begin
                  name := MixCase(Squeeze(Copy(MemInfo, namepos, SizeOf(name))));
                  Val(Squeeze(Copy(MemInfo, sentpos, 4)), sent, VErr);
                  oldest := Copy(MemInfo, oldestpos, SizeOf(oldest));
                  newest := Copy(MemInfo, newestpos, SizeOf(newest));
               end
               else if Copy(MemInfo,1,6)='Notes:' then begin
                  notes:=MemInfo;
                  Delete(notes,1,notespos-1);
               end
               else if BBS1='' then begin
                  BBS1:=MemInfo;
                  Delete(BBS1,1,BBS1pos-1);
               end
               else if BBS2='' then begin
                  BBS2:=MemInfo;
                  Delete(BBS2,1,BBS2pos-1);
               end
             END; {with}
         until DataEnd OR (Copy(MemInfo,1,6)='Notes:');

         if list <> nil then
           list^.next:=MemberInfo
         else
           anchor := MemberInfo;

         list:=MemberInfo;
      end {if}
    END; {while}
    close(infile); iocheck(ioresult);
    clrEOL;
    list:=anchor;
  end;
  write('done!');
  BuildList:=Members;
end;

function ReadDAT(var list: MemLink; const DATFileName: string): word;
const recSize  = 128;
type  buffer   = array [1..recSize] of char;
var
  MemInfo : buffer;
  anchor, newMEM  : MemLink;

  NewName : string;
  NextMes : word;
  VErr    : integer;

  CrnDate : string[8];
  confnum : word;
  echoed,
  private : boolean;
  BBStemp : string;

  dfile   : file;
  count,
  Members : word;
begin
  Members:=0;
  NextMes:=2;
  assign (dfile, DATFileName);
  reset (dfile,1); iocheck(ioresult);
  repeat
    updatecursor;
    for count:=1 to NextMes do begin
      blockread (dfile, MemInfo, recSize);
      if (ioresult<>0) then continue;
    end;
    BBStemp:='';
    Val(Squeeze(Copy(MemInfo,117,6)), NextMes, VErr);
    if NextMes < 1 then NextMes := 1;

    confnum:=Ord(MemInfo[125]) * 256 + Ord(MemInfo[124]);
    private:= (MemInfo[1]='+') OR (MemInfo[1]='*');

    if (confnum = ConfNumb) and (NOT private) then BEGIN
      High_Message:=GetNewHigh(High_Message, Copy(MemInfo,2,7));
      NewName:=MixCase(Squeeze(Copy(MemInfo, 47, 25)));
      if (NewName <> '') AND (Pos(#0,NewName) < 1)
          AND (NewName[1] in ['A'..'Z']) then begin
        anchor:=list;
        while (list <> nil) and (list^.name <> NewName) do list:=list^.next;
        if list = nil then begin
          list:=anchor;
          inc(Members);
          new(newMEM);
          with newMEM^ do BEGIN
            name := NewName;
            sent := 1;
            oldest := Copy(MemInfo,9,8);
            newest := oldest;

            Echoed:=(MemInfo[128] = '*');
            while NextMes > 1 do begin
              if length(BBStemp) > 127 then
                Delete(BBStemp,1,(length(BBStemp)-127));
              blockread (dfile, MemInfo, recSize); iocheck(ioresult);
              BBStemp:=BBStemp+MemInfo;
              system.dec(NextMes);
            end;
            BBStemp:=GetOriginLine(BBStemp);

            if (BBStemp[2] IN [#42,#254]) then
              BBS1 := BBStemp
            else
              if Echoed then
                BBS1 := ' * Unknown origin'
              else
                BBS1 := ' * Local origin';

            BBS2 := '';
            notes := ' !New!';
            next:=list;
          END;
          list:=newMEM;
        end {if list = nil then}
        else begin
          with list^ do begin
             sent := (sent)+1;
             CrnDate := Copy(MemInfo,9,8);
             if Num_Days(CrnDate) < Num_Days(oldest) then oldest:=CrnDate;
             if Num_Days(CrnDate) > Num_Days(newest) then newest:=CrnDate;

             Echoed:=(MemInfo[128] = '*');
             while NextMes > 1 do begin
               if length(BBStemp) > 127 then
                 Delete(BBStemp,1,(length(BBStemp)-127));
               blockread (dfile, MemInfo, recSize); iocheck(ioresult);
               BBStemp:=BBStemp+MemInfo;
               system.dec(NextMes);
             end;
             BBStemp:=GetOriginLine(BBStemp);

             if ((BBStemp[2] IN [#42,#254]) and Echoed) then
              if (MiddleOf(BBStemp) <> MiddleOf(BBS1)) then
                 begin  { make BBStemp the most recent }
                   BBS2:=BBS1;
                   BBS1:=BBStemp
                 end
              else BBS1:=BBStemp;

          end;
          list:=anchor
        end  {if list = nil then ... else}
      end  {if (NewName <> '') AND (Pos(#0,NewName) < 1)
              AND (NewName[1] in ['A'..'Z']) then}
    end  {if (confnum = ConfNumb) and (NOT private) then}
  until EOF(dfile);
  ClrEOL;
  close (dfile); iocheck(ioresult);
  ReadDat:=Members;
end;
{===========================================================================}

function Relevant(Const s: string; Const len: byte): string;
begin
  Relevant:=Copy(s,1,len);
end;

procedure GetSortField(Const pstr: string);
begin
  field := Upper(pstr);
  if field = '' then field:='NAME';
  inverse:=(field[1]='-');
  if inverse then delete(field,1,1);
  field:=Relevant(field,3);
end;

function CompareFields(Const cnode, cnode2: MemLink): boolean;
begin
  { Originally was: (node^.name > node2^.next^.name) }

  if field = 'NAM' then begin
      if inverse then
        CompareFields:=(cnode^.NAME <= cnode2^.next^.NAME)
      else
        CompareFields:=(cnode^.NAME >= cnode2^.next^.NAME)
    end
  else
  if field = 'SEN' then begin
      if inverse then
        CompareFields:=(cnode^.SENT <= cnode2^.next^.SENT)
      else
        CompareFields:=(cnode^.SENT >= cnode2^.next^.SENT)
    end
  else
  if field = 'OLD' then begin
      if inverse then
        CompareFields:=(Num_Days(cnode^.OLDEST) <= Num_Days(cnode2^.next^.OLDEST))
      else
        CompareFields:=(Num_Days(cnode^.OLDEST) >= Num_Days(cnode2^.next^.OLDEST))
    end
  else
  if field = 'NEW' then begin
      if inverse then
        CompareFields:=(Num_Days(cnode^.NEWEST) <= Num_Days(cnode2^.next^.NEWEST))
      else
        CompareFields:=(Num_Days(cnode^.NEWEST) >= Num_Days(cnode2^.next^.NEWEST))
    end

end;
{===========================================================================}

procedure SortLinkedList(var list: MemLink);  {By Ian Lin, found in SWAG}
var
  list2,                       {first and second lists, temporary }
  node,                        {  Pointers to nodes in the lists  }
  node2  : MemLink;
begin
  write('Sorting membership list, please wait ... ');

  new(list2);            {begin NEW sorted list}
  list2^.next := list;   {steal the first node of list For list2}
  list := list^.next;
  list2^.next^.next := nil;
  While list <> nil do
  begin                  {now steal 'em all and add them in order}
    node := list;        {point node to first node in LIST}
    list := list^.next;  {advance LIST Pointer one node, first node is now seperate}
    node2 := list2;      {ready to use NODE2 to find the correct entry point}

    While (node2^.next <> nil) and CompareFields(node,node2) do
                                   { (node^.name > node2^.next^.name) }
      node2 := node2^.next;    {advance NODE2 as needed until it marks the
                                  right place For NODE to be inserted}

    node^.next:= node2^.next;  {insert NODE into the new list, in the correct order}

    node2^.next := node; {connect node to the previous nodes in the new list, if any}
    updateCursor;
  end;
  list := list2^.next;   {point LIST back to the top of the list, now in order}

  list2^.next := nil;
  dispose (list2);
  clrEOL;
  write('done!');
end;
{===========================================================================}

procedure WriteList(var list: MemLink; Const fname: string; Const mems: word);
VAR
  MemList : text;
  chain : MemLink;
BEGIN
  Assign(MemList,fname);
  ReWrite(MemList); iocheck(ioresult);
  write('Writing membership list, please wait ... ');

  writeln(MemList,'CPT (Conference Participation Tracker) text database.');
  writeln(MemList);
  writeln(MemList,'Conference participation data for conference: ',confnumb);
  writeln(MemList,'Total participants: ',mems);
  writeln(MemList,'High message: ',High_Message);
  writeln(MemList);
  writeln(MemList,'  This permanent data file may be edited, relatively freely.  Beware that:');
  writeln(MemList);
  writeln(MemList,'      1) The colon+space combination (: ) before each name must remain.');
  writeln(MemList,'      2) The offset of the names and dates cannot be changed.');
  writeln(MemList,'      3) The offset of the number of messages sent cannot be changed.');
  writeln(MemList,'      4) The label "Notes:" before the notes must not be altered,');
  writeln(MemList,'           BUT about 70 characters of notes may be added after the label.');
  writeln(MemList,'      5) The delimiting lines between each participant must not be altered.');
  writeln(MemList,'      6) The "High message: #####" line above should be left as is.');
  writeln(MemList,'      7) Invalid records can and should be removed (5 lines make up a record).');
  writeln(MemList);

  while list <> nil do begin
    updatecursor;
    with list^ do BEGIN
      writeln(MemList,DelimitLine);
      write  (MemList,': ',name,#32:(26-length(name)),'sent ',sent:4,
                              ', between ',oldest,' and ',newest);
      writeln(MemList,' (',1+(Num_Days(newest)-Num_Days(oldest)),' days)');
      writeln(MemList,bbs1);
      writeln(MemList,bbs2);
      writeln(MemList,'Notes:',notes);
    END;
    chain:=list;
    list:=list^.next;
    dispose(chain);
  end;
  Writeln(MemList,EndOfDB);
  clrEOL;
  close(MemList); iocheck(ioresult);
  write('done!');
END;
{===========================================================================}

procedure WriteStats(var list: MemLink; Const fname: string; Const mems: word);
CONST
  Header='Name                      '+
         'Sent    Oldest     Newest  Days  Avg.';
VAR
  MemList : text;
  chain : MemLink;
  TotalSent : longint;
  count,
  rank,
  LastSent : word;
  days : word;
BEGIN
  Assign(MemList,fname);
  ReWrite(MemList); iocheck(ioresult);
  write('Writing membership list, please wait ... ');

  writeln(MemList);
  writeln(MemList,' Conference participation statistics for conference ',confnumb);
  writeln(MemList,'    Total participants: ',mems);
  writeln(MemList);
  TotalSent:=0;
  if (field='SEN') and inverse then begin
    count:=0;
    rank:=1;
    LastSent:=65535;
    writeln(MemList,'Rank   ',Header);
    write(MemList,'=-=-=-=-');
  end
  else
    writeln(MemList,Header);
  writeln(MemList,Copy(DelimitLine,1,63));
  while (list <> nil) do begin
    updatecursor;
    with list^ do BEGIN
      TotalSent:=TotalSent+sent;
      if (field='SEN') and inverse then begin
        inc(count);
        if sent<>LastSent then begin
          rank:=count;
          LastSent:=sent
        end;
        write (MemList,rank:4,':  ');
      end;
      write (MemList,name,#32:(26-length(name)), sent:4, oldest:11, newest:11);
      days:=1+Num_Days(newest)-Num_Days(oldest);
      write(MemList,days:5);
      writeln(MemList,(sent/days):6:2);
    END;
    chain:=list;
    list:=list^.next;
    dispose(chain);
  end;
  Writeln(MemList);
  writeln(MemList,'Total participants: ',mems,
             ' ... total sent: ', TotalSent,
             ' ... average: ',(TotalSent/mems):1:2);
  clrEOL;
  close(MemList); iocheck(ioresult);
  write('done!');
END;
{===========================================================================}

procedure InitArcQWK;
var
  epath, cpath  : pathstr;
    {epath & cpath are fully qualified pathnames of .exe & .cfg files}
  edir: dirstr; ename: namestr; eext: extstr;
  config        : text;
  configline    : string[80];
begin
  epath := (paramstr (0));
  fsplit(fexpand(epath),edir,ename,eext); { break up path into components }
  cpath := edir+ename+'.cfg';

  UnArcQWK:='pkunzip -# -o';
  if fileexists(cpath) then
  begin
    assign (config, cpath);
    reset (config); iocheck(ioresult);
    repeat  { find vars }
      readln(config,configline);
      if (length(configline) > 10) and
        (copy(configline,1,9) = 'UNARCQWK=') then
        UnArcQWK := Copy(configline,10,length(configline)-9);
    until eof(config); { loop back to read another line }
    close (config);
  end;
end;
{===========================================================================}

function ExtractDAT(const DATfile, DATFileName : string): boolean;
var
  x,y : byte;
begin
  x:=WhereX;
  y:=WhereY;
  write('> ',UnArcQWK);
  swapvectors;
     exec (getenv ('COMSPEC'),' /c '+UnArcQWK+' '+DATfile+' '+DATFileName);
     if doserror <> 0 then halt(5);
  swapvectors;
  GotoXY(x,y);
  ClrEOL;
  cursorOff;
  ExtractDAT:=fileexists(DATFileName)
end;
{===========================================================================}

procedure EraseFile(const DATfile : string);
var
  df : file;
begin
  if fileexists(DATfile) then begin
    assign(df, DATfile);
    erase(df); iocheck(ioresult);
  end;
end;
{===========================================================================}

begin
  CheckBreak:=true;
  cursorOff;
end.
