PROGRAM Conference_Participation_Tracker_PROTECTED_MODE;
{$M 5120} { reduce stack due to few variables }
{$N-,E- no math support needed}
{$X- function calls may not be discarded}
{$I-} {disable I/O checking - trap errors by checking IOResult}
USES CRT, DOS, NUMDAYS, CPT_COMN;

VAR SavedExitProc: Pointer;

{===========================================================================}

procedure CustomExit; far;
{---- Always exit through here ----}
const
  progdesc = 'CPT-p - Free DOS utility: Conference Participation Tracker. [Protected mode]';
  usage    = 'Usage: CPT-p <QWKfile(s)> <CPT file>';
  note1    = 'Note:  <CPT file>  is any DOS filename, with an embedded conference number,';
  note2    = '                   and with or without a file extension.';
  examples = 'Examples:';
  example1 = '    CPT-p \qwks\kandy.qwk 123';
  example2 = '    CPT-p channel1.qw* cnf_456.mem';
  example3 = '    CPT-p c:\qwk\lun*.qwk c:\conf\mem_78.dat';
  example4 = '    CPT-p *.qwk 90';

begin
  if ErrorAddr <> nil then
  begin
    writeln('An unanticipated occured, please contact DDA with the following data:');
    writeln('Address = ', Seg(ErrorAddr^), ':', Ofs(ErrorAddr^));
    writeln('Code    = ', Exitcode);
  end;

  if (ExitCode > 0) then begin
    writeln(progdesc);
    writeln(author);    writeln;
    writeln(usage);     writeln;
    writeln(note1);
    writeln(note2);     writeln;
    writeln(examples);  writeln;
    writeln(example1);
    writeln(example2);
    writeln(example3);
    writeln(example4);  writeln;
    if (ExitCode < 255) then
      WriteError(ExitCode);
  end;

  cursorOn;
  ExitProc := SavedExitProc
end;
{===========================================================================}

CONST
    DATFileName = 'MESSAGES.DAT';

VAR MemberInfo  : MemLink;
    Members     : word;
    MemFileName : pathstr;

    QWKpath    : pathstr;    { QWK file path.          }
    QWKdir     : dirstr;     { QWK file dir.           }
    dirinfo    : searchrec;  { contains filespec info. }

BEGIN
  SavedExitProc := ExitProc;
  ExitProc := @CustomExit;

  if ParamCount <> 2 then halt(255);
  GetSortField('NAME');
  InitArcQWK;

  MemFileName:=GetMFN(ParamStr(2));
  writeln('CPT-p - Conference Participation Tracker [Protected mode version]');
  writeln('CPT-p ', version, ' updating ',MemFileName);
  write('Checking available memory for data ... done!'); WriteMemAvail;
  Members:=BuildList(MemberInfo, MemFileName); WriteMemAvail;
  QWKdir:=GetQWKdir(ParamStr(1), QWKpath);

  findfirst(QWKpath, archive, dirinfo); if doserror <> 0 then halt(2);
  while doserror = 0 do
  begin
    write('Reading ',QWKdir+dirinfo.name,' ... ');
    EraseFile(DATFileName);
    if ExtractDAT(QWKdir+dirinfo.name, DATFileName) then begin
      Members:=Members+ReadDAT(MemberInfo, DATFileName);
        write('done!');  WriteMemAvail;
      EraseFile(DATFileName);
    end
    else
      writeln('bad QWK - skipping.');
    findnext(dirinfo);
  end;

  if MemberInfo <> nil then begin
    SortLinkedList(MemberInfo); WriteMemAvail;
    WriteList(MemberInfo, MemFileName, Members); WriteMemAvail;
  end;
  writeln('Mission accomplished!');
END.
